<?php
// archivo ResumenTest.php
// Verifica si los datos están siendo enviados a través de la URL o el formulario
if (isset($_GET['name']) && isset($_GET['modalidad_deporte']) && isset($_GET['puntaje']) && isset($_GET['recomendaciones'])) {
    // Recibe los datos
    $name = $_GET['name'];
    $modalidad_deporte = $_GET['modalidad_deporte'];
    $puntaje = $_GET['puntaje'];
    $recomendaciones = $_GET['recomendaciones'];
} else {
    // Si los datos no están disponibles, muestra un mensaje de error
    echo "Datos incompletos.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen del Test</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
    </style>
</head>
<body>
    <h1>Resumen del Test</h1>

    <table>
        <thead>
            <tr>
                <th>Nombre del Usuario</th>
                <th>Modalidad de Actividad Física</th>
                <th>Puntaje</th>
                <th>Recomendaciones</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo htmlspecialchars($name); ?></td>
                <td><?php echo htmlspecialchars($modalidad_deporte); ?></td>
                <td><?php echo htmlspecialchars($puntaje); ?></td>
                <td><?php echo nl2br(htmlspecialchars($recomendaciones)); ?></td>
            </tr>
        </tbody>
    </table>
</body>
</html>
