<?php 
// archivo: analisis_estadistico_desglosado_global_habilidades_artes.php
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Modalidades de Actividad Física</title>
  <link rel="stylesheet" href="stylesestsdistic.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-zoom@1.2.1/dist/chartjs-plugin-zoom.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
  <script src="mobileAppAnaEstDesGloHabArt.js"></script>
  <style>
    .chart-container { width: 800px; margin: 20px auto; }
    .btn-container { text-align: center; margin-top: 20px; }
    .btn { padding: 10px 20px; font-size: 16px; cursor: pointer; margin: 5px; }
    .btn-print { background-color: #007bff; color: white; border: none; }
    .btn-pdf { background-color: #28a745; color: white; border: none; }
  </style>
</head>
<body>
  <h1>Gráficas de Habilidades Artisticas, Desglosadas por Modalidad de Actividad Física</h1>
  
 <div class="btn-container">
    <button class="btn btn-print" onclick="window.print()">Imprimir</button>
    <button class="btn btn-pdf" onclick="generatePDF()">Descargar PDF</button>
  </div>

  <div id="chartsContainer"></div>

  <script>
    function generatePDF() {
      const { jsPDF } = window.jspdf;
      const doc = new jsPDF({ orientation: "scape", unit: "mm", format: "a4" });
      
      doc.setFontSize(12);
      doc.text("Gráficas de Habilidades Artisticas, Desglosadas por Modalidad de Actividad Física", 20, 20);
      
      const chartsContainer = document.getElementById("chartsContainer");
      html2canvas(chartsContainer, { scale: 1 }).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const imgWidth = 200; // Ajusta el ancho de la imagen
        const imgHeight = 250;
        doc.addImage(imgData, "PNG", 1, 30, imgWidth, imgHeight);
        doc.save("habilidades_artisticas.pdf");
      });
    }
  </script>
</body>
</html>
<?php
include "footer.php";
include "estilos.php";
?>