<?php
//archivo analisis_estadistico_individual_habilidades_artes.php

// Obtener el nombre del participante desde el parámetro GET
$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante
$modalidad = isset($_GET['mod']) ? $_GET['mod'] : '';

 ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Análisis Estadístico de Datos</title>
  <link rel="stylesheet" href="stylesestsdistic.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="js/appIndHabArt.js"></script>
  <style>
    .chart-container { width: 800px; margin: 20px auto; }
    .btn-container { text-align: center; margin-top: 20px; }
    .btn { padding: 10px 20px; font-size: 16px; cursor: pointer; margin: 5px; }
    .btn-print { background-color: #007bff; color: white; border: none; }
    .btn-pdf { background-color: #28a745; color: white; border: none; }
  </style>
</head>
<body>
    <h1>Gráficas de Análisis Estadístico Individual Habilidades Artisticas : </h1>

   <div class="btn-container">
    <button class="btn btn-print" onclick="window.print()">Imprimir</button>
    <button class="btn btn-pdf" onclick="generatePDF()">Descargar PDF</button>
  </div>
  
    <label for="participant_name">Nombre del Beneficiario:</label>
    <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" readonly>

        <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" readonly>

         <label for="modalidad_deporte">Modalidad Deportiva:</label>
        <input type="text" id="modalidad_deporte" name="modalidad_deporte" value="<?= htmlspecialchars($modalidad) ?>" readonly>
   
    <div class="chart-container">
        <canvas id="evolutionChart"></canvas>
    </div>
    <div class="chart-container">
        <canvas id="pieChart"></canvas>
    </div>

  <!-- Se incluye el script de la aplicación -->
  <script src="appIndHabArt.js"></script>
<script>
    function generatePDF() {
      const { jsPDF } = window.jspdf;
      const doc = new jsPDF({ orientation: "scape", unit: "mm", format: "a4" });      
      doc.setFontSize(18);
      doc.text("Gráficas del Test Individual de Habilidades Artisticas", 20, 20);
      
      const charts = document.querySelectorAll(".chart-container canvas");
      let yOffset = 30;
      let pageHeight = doc.internal.pageSize.height;

      function addChartToPDF(chart, callback) {
        html2canvas(chart, { scale: 2 }).then(canvas => {
          const imgData = canvas.toDataURL("image/png");
          const imgWidth = 180;
          const imgHeight = (canvas.height * imgWidth) / canvas.width;
          
          if (yOffset + imgHeight > pageHeight - 10) {
            doc.addPage();
            yOffset = 30;
          }
          
          doc.addImage(imgData, "PNG", 10, yOffset, imgWidth, imgHeight);
          yOffset += imgHeight + 10;
          
          callback();
        });
      }
      
      let chartIndex = 0;
      function processNextChart() {
        if (chartIndex < charts.length) {
          addChartToPDF(charts[chartIndex], () => {
            chartIndex++;
            processNextChart();
          });
        } else {
          doc.save("test_habilidades_artisticas_individual.pdf");
       }
      }
      
      processNextChart();
    }
  </script>

</body>
</html>
<?php
include "footer.php";
include "estilos.php";
?>