// archivo js/appHabArt.js

const colorPalette = [
  { border: 'rgba(75, 192, 192, 1)', background: 'rgba(75, 192, 192, 0.2)' },
  { border: 'rgba(75, 192, 192, 1)', background: 'rgba(75, 192, 192, 0.4)' },
  { border: 'rgba(75, 192, 192, 1)', background: 'rgba(75, 192, 192, 0.8)' },
  { border: 'rgba(255, 99, 132, 1)', background: 'rgba(255, 99, 132, 0.2)' },
  { border: 'rgba(255, 99, 132, 1)', background: 'rgba(255, 99, 132, 0.4)' },
  { border: 'rgba(255, 99, 132, 1)', background: 'rgba(255, 99, 132, 0.8)' },
  { border: 'rgba(54, 162, 235, 1)', background: 'rgba(54, 162, 235, 0.2)' },
  { border: 'rgba(54, 162, 235, 1)', background: 'rgba(54, 162, 235, 0.8)' },
  { border: 'rgba(153, 102, 255, 1)', background: 'rgba(153, 102, 255, 0.2)' },
  { border: 'rgba(153, 102, 255, 1)', background: 'rgba(153, 102, 255, 0.4)' },
  { border: 'rgba(153, 102, 255, 1)', background: 'rgba(153, 102, 255, 0.6)' },
  { border: 'rgba(153, 102, 255, 1)', background: 'rgba(153, 102, 255, 0.8)' },
  { border: 'rgba(153, 102, 255, 1)', background: 'rgba(153, 102, 255, 0.9)' },
  { border: 'rgba(199, 199, 199, 1)', background: 'rgba(199, 199, 199, 0.2)' },
  { border: 'rgba(199, 199, 199, 1)', background: 'rgba(199, 199, 199, 0.4)' },
  { border: 'rgba(199, 199, 199, 1)', background: 'rgba(199, 199, 199, 0.6)' },
  { border: 'rgba(199, 199, 199, 1)', background: 'rgba(199, 199, 199, 0.8)' },
  { border: 'rgba(199, 199, 199, 1)', background: 'rgba(199, 199, 199, 0.9)' }
];

// Función para obtener datos desde un endpoint PHP con manejo de errores
async function fetchData(url) {
  try {
    const response = await fetch(url);
    if (!response.ok) {
      throw new Error(`Error en la petición HTTP: ${response.status}`);
    }
    return await response.json();
  } catch (error) {
    console.error(`Fetch error en ${url}:`, error);
    return null;
  }
}

// Inicialización de la gráfica de evolución (línea) con múltiples datasets
async function initEvolutionChart() {
  const evolutionData = await fetchData('get_evolutionHabArt_data.php');
  if (!evolutionData) {
    console.error("No se pudieron obtener datos para la gráfica de evolución.");
    return;
  }
  
  const labels = evolutionData.map(item => item.mes);
  
  const aciertosPregunta1 = evolutionData.map(item => item.pregunta1 ? item.pregunta1.total_aciertos : 0);
  const aciertosPregunta2 = evolutionData.map(item => item.pregunta2 ? item.pregunta2.total_aciertos : 0);
  const aciertosPregunta3 = evolutionData.map(item => item.pregunta3 ? item.pregunta3.total_aciertos : 0);
  const aciertosPregunta4 = evolutionData.map(item => item.pregunta4 ? item.pregunta4.total_aciertos : 0);
  const aciertosPregunta5 = evolutionData.map(item => item.pregunta5 ? item.pregunta5.total_aciertos : 0);
  const aciertosPregunta6 = evolutionData.map(item => item.pregunta6 ? item.pregunta6.total_aciertos : 0);
  const aciertosPregunta7 = evolutionData.map(item => item.pregunta7 ? item.pregunta7.total_aciertos : 0);
  const aciertosPregunta8 = evolutionData.map(item => item.pregunta8 ? item.pregunta8.total_aciertos : 0);
  const aciertosPregunta9 = evolutionData.map(item => item.pregunta9 ? item.pregunta9.total_aciertos : 0);
  const aciertosPregunta10 = evolutionData.map(item => item.pregunta10 ? item.pregunta10.total_aciertos : 0);
  const aciertosPregunta11 = evolutionData.map(item => item.pregunta11 ? item.pregunta11.total_aciertos : 0);
  const aciertosPregunta12 = evolutionData.map(item => item.pregunta12 ? item.pregunta12.total_aciertos : 0);
  const aciertosPregunta13 = evolutionData.map(item => item.pregunta13 ? item.pregunta13.total_aciertos : 0);
  const aciertosPregunta14 = evolutionData.map(item => item.pregunta14 ? item.pregunta14.total_aciertos : 0);
  const aciertosPregunta15 = evolutionData.map(item => item.pregunta15 ? item.pregunta15.total_aciertos : 0);
  const aciertosPregunta16 = evolutionData.map(item => item.pregunta16 ? item.pregunta16.total_aciertos : 0);
  const aciertosPregunta17 = evolutionData.map(item => item.pregunta17 ? item.pregunta17.total_aciertos : 0);
  const aciertosPregunta18 = evolutionData.map(item => item.pregunta18 ? item.pregunta18.total_aciertos : 0);

  const canvasLine = document.getElementById('evolutionChart');
  if (!canvasLine) {
    console.error('No se encontró el elemento canvas con id "evolutionChart".');
    return;
  }
  
  const ctxLine = canvasLine.getContext('2d');
  new Chart(ctxLine, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [
        {
          label: 'DP. Precisión',
          data: aciertosPregunta1,
          borderColor: colorPalette[0].border,
          backgroundColor: colorPalette[0].background,
          fill: true,
        },
        {
          label: 'DP. Colores',
          data: aciertosPregunta2,
          borderColor: colorPalette[1].border,
          backgroundColor: colorPalette[1].background,
          fill: true,
        },
        {
          label: 'DP. Organización',
          data: aciertosPregunta3,
          borderColor: colorPalette[2].border,
          backgroundColor: colorPalette[2].background,
          fill: true,
        },
        {
          label: 'EM. Destreza',
          data: aciertosPregunta4,
          borderColor: colorPalette[3].border,
          backgroundColor: colorPalette[3].background,
          fill: true,
        },
        {
          label: 'EM. Fuerza',
          data: aciertosPregunta5,
          borderColor: colorPalette[4].border,
          backgroundColor: colorPalette[4].background,
          fill: true,
        },
        {
          label: 'EM. Coordinación',
          data: aciertosPregunta6,
          borderColor: colorPalette[5].border,
          backgroundColor: colorPalette[5].background,
          fill: true,
        },
        {
          label: 'M. Ritmo',
          data: aciertosPregunta7,
          borderColor: colorPalette[6].border,
          backgroundColor: colorPalette[6].background,
          fill: true,
        },
        {
          label: 'M. Tempo',
          data: aciertosPregunta8,
          borderColor: colorPalette[7].border,
          backgroundColor: colorPalette[7].background,
          fill: true,
        },
        {
          label: 'Dan. Coordinación',
          data: aciertosPregunta9,
          borderColor: colorPalette[8].border,
          backgroundColor: colorPalette[8].background,
          fill: true,
        },
        {
          label: 'Dan. Equilibrio',
          data: aciertosPregunta10,
          borderColor: colorPalette[9].border,
          backgroundColor: colorPalette[9].background,
          fill: true,
        },
        {
          label: 'Dan. Control Corporal',
          data: aciertosPregunta11,
          borderColor: colorPalette[10].border,
          backgroundColor: colorPalette[10].background,
          fill: true,
        },
        {
          label: 'Dan. Espontaneidad',
          data: aciertosPregunta12,
          borderColor: colorPalette[11].border,
          backgroundColor: colorPalette[11].background,
          fill: true,
        },
        {
          label: 'Dan. Creatividad',
          data: aciertosPregunta13,
          borderColor: colorPalette[12].border,
          backgroundColor: colorPalette[12].background,
          fill: true,
        },
        {
          label: 'T. Expresión',
          data: aciertosPregunta14,
          borderColor: colorPalette[13].border,
          backgroundColor: colorPalette[13].background,
          fill: true,
        },
        {
          label: 'T. Voz',
          data: aciertosPregunta15,
          borderColor: colorPalette[14].border,
          backgroundColor: colorPalette[14].background,
          fill: true,
        },
        {
          label: 'T. Corporalidad',
          data: aciertosPregunta16,
          borderColor: colorPalette[15].border,
          backgroundColor: colorPalette[15].background,
          fill: true,
        },
        {
          label: 'T. Modulación',
          data: aciertosPregunta17,
          borderColor: colorPalette[16].border,
          backgroundColor: colorPalette[16].background,
          fill: true,
        },
        {
          label: 'T. Articulación',
          data: aciertosPregunta18,
          borderColor: colorPalette[17].border,
          backgroundColor: colorPalette[17].background,
          fill: true,
        }
      ]
    },
    options: {
      responsive: true,
      plugins: {
        zoom: {
          zoom: {
            wheel: { enabled: true },
            pinch: { enabled: true },
            mode: 'x'
          },
          pan: { enabled: true, mode: 'x' }
        }
      },
      scales: {
        x: { title: { display: true, text: 'Mes/Año' } },
        y: { title: { display: true, text: 'Puntaje' } }
      }
    }
  });
}

// Inicialización de la gráfica de torta (pie chart) con porcentajes en tooltips y en labels
async function initPieChart() {
  const pieData = await fetchData('get_pieHabArt_data.php');
  if (!pieData) {
    console.error("No se pudieron obtener datos para la gráfica de torta.");
    return;
  }
  
  const pieLabels = pieData.map(item => item.test);
  const pieValues = pieData.map(item => item.total_aciertos);
  const totalAciertos = pieValues.reduce((acc, val) => acc + val, 0);
  
  const canvasPie = document.getElementById('pieChart');
  if (!canvasPie) {
    console.error('No se encontró el elemento canvas con id "pieChart".');
    return;
  }
  
  const ctxPie = canvasPie.getContext('2d');
  new Chart(ctxPie, {
    type: 'pie',
    data: {
      labels: pieLabels,
      datasets: [{
        data: pieValues,
        backgroundColor: [
          colorPalette[0].border,
          colorPalette[1].background,
          colorPalette[2].background,
          colorPalette[3].border,
          colorPalette[4].background,
          colorPalette[5].background,
          colorPalette[6].border,
          colorPalette[7].background,
          colorPalette[8].border,
          colorPalette[9].background,
          colorPalette[10].background,
          colorPalette[11].background,
          colorPalette[12].background,
          colorPalette[13].border,
          colorPalette[14].background,
          colorPalette[15].background,
          colorPalette[16].background,
          colorPalette[17].background
        ]
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'top' },
        tooltip: {
          callbacks: {
            label: function(context) {
              const label = context.label || '';
              const value = context.raw;
              const percentage = totalAciertos > 0 ? ((value / totalAciertos) * 100).toFixed(2) : 0;
              return `${label}: ${percentage}% (${value})`;
            }
          }
        },
        datalabels: {
          color: '#fff',
          formatter: function(value) {
            const percentage = totalAciertos > 0 ? ((value / totalAciertos) * 100).toFixed(2) : 0;
            return percentage + '%';
          }
        }
      }
    },
    plugins: [ChartDataLabels]
  });
}

window.onload = function() {
  initEvolutionChart();
  initPieChart();
};
