// archivo appIndObs.js
const colorPalette = [
  { border: 'rgba(75, 192, 192, 1)', background: 'rgba(75, 192, 192, 0.2)' },
  { border: 'rgba(255, 99, 132, 1)', background: 'rgba(255, 99, 132, 0.2)' },
  { border: 'rgba(255, 206, 86, 1)', background: 'rgba(255, 206, 86, 0.2)' },
  { border: 'rgba(54, 162, 235, 1)', background: 'rgba(54, 162, 235, 0.2)' },
  { border: 'rgba(153, 102, 255, 1)', background: 'rgba(153, 102, 255, 0.2)' },
  { border: 'rgba(255, 159, 64, 1)', background: 'rgba(255, 159, 64, 0.2)' },
  { border: 'rgba(199, 199, 199, 1)', background: 'rgba(199, 199, 199, 0.2)' },
  { border: 'rgba(83, 102, 255, 1)', background: 'rgba(83, 102, 255, 0.2)' },
  { border: 'rgba(255, 102, 255, 1)', background: 'rgba(255, 102, 255, 0.2)' },
  { border: 'rgba(102, 255, 102, 1)', background: 'rgba(102, 255, 102, 0.2)' }
];

// Función para obtener datos desde un endpoint PHP con manejo de errores
async function fetchData(url) {
  try {
    const response = await fetch(url);
    if (!response.ok) {
      throw new Error(`Error en la petición HTTP: ${response.status}`);
    }
    return await response.json();
  } catch (error) {
    console.error(`Fetch error en ${url}:`, error);
    return null;
  }
}

// Inicialización de la gráfica de evolución (línea) con múltiples datasets
async function initEvolutionChart() {
  const evolutionData = await fetchData('get_evolutionIndObs_data.php');
  if (!evolutionData) {
    console.error("No se pudieron obtener datos para la gráfica de evolución.");
    return;
  }
  
  const labels = evolutionData.map(item => item.mes);
  
  const aciertosPregunta1 = evolutionData.map(item => item.evaluacion_impacto_pregunta1 ? item.evaluacion_impacto_pregunta1.total_pregunta : 0);
  const aciertosPregunta2 = evolutionData.map(item => item.evaluacion_impacto_pregunta2 ? item.evaluacion_impacto_pregunta2.total_pregunta : 0);
  const aciertosPregunta3 = evolutionData.map(item => item.evaluacion_impacto_pregunta3 ? item.evaluacion_impacto_pregunta3.total_pregunta : 0);
  const aciertosPregunta4 = evolutionData.map(item => item.evaluacion_impacto_pregunta4 ? item.evaluacion_impacto_pregunta4.total_pregunta : 0);
  const aciertosPregunta5 = evolutionData.map(item => item.evaluacion_impacto_pregunta5 ? item.evaluacion_impacto_pregunta5.total_pregunta : 0);
  const aciertosPregunta6 = evolutionData.map(item => item.evaluacion_impacto_pregunta6 ? item.evaluacion_impacto_pregunta6.total_pregunta : 0);
  const aciertosPregunta7 = evolutionData.map(item => item.evaluacion_impacto_pregunta7 ? item.evaluacion_impacto_pregunta7.total_pregunta : 0);
  const aciertosPregunta8 = evolutionData.map(item => item.evaluacion_impacto_pregunta8 ? item.evaluacion_impacto_pregunta8.total_pregunta : 0);
  const aciertosPregunta9 = evolutionData.map(item => item.evaluacion_impacto_pregunta9 ? item.evaluacion_impacto_pregunta9.total_pregunta : 0);
  const aciertosPregunta10 = evolutionData.map(item => item.evaluacion_impacto_pregunta10 ? item.evaluacion_impacto_pregunta10.total_pregunta : 0);

  const canvasLine = document.getElementById('evolutionChart');
  if (!canvasLine) {
    console.error('No se encontró el elemento canvas con id "evolutionChart".');
    return;
  }
  
  const ctxLine = canvasLine.getContext('2d');
  new Chart(ctxLine, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [
        {
          label: 'Participar Actividades Académicas',
          data: aciertosPregunta1,
          borderColor: colorPalette[0].border,
          backgroundColor: colorPalette[0].background,
          fill: true,
        },
        {
          label: 'Atención en Clases',
          data: aciertosPregunta2,
          borderColor: colorPalette[1].border,
          backgroundColor: colorPalette[1].background,
          fill: true,
        },
        {
          label: 'Reacción ante Tareas Desafiantes',
          data: aciertosPregunta3,
          borderColor: colorPalette[2].border,
          backgroundColor: colorPalette[2].background,
          fill: true,
        },
        {
          label: 'Interés por Aprender Nuevos Conocimientos',
          data: aciertosPregunta4,
          borderColor: colorPalette[3].border,
          backgroundColor: colorPalette[3].background,
          fill: true,
        },
        {
          label: 'Colaboración con Compañeros',
          data: aciertosPregunta5,
          borderColor: colorPalette[4].border,
          backgroundColor: colorPalette[4].background,
          fill: true,
        },
        {
          label: 'Actitud de Aprendizaje',
          data: aciertosPregunta6,
          borderColor: colorPalette[5].border,
          backgroundColor: colorPalette[5].background,
          fill: true,
        },
        {
          label: 'Estrategia para Resolver Problemas',
          data: aciertosPregunta7,
          borderColor: colorPalette[6].border,
          backgroundColor: colorPalette[6].background,
          fill: true,
        },
        {
          label: 'Organización del Tiempo en el Aula',
          data: aciertosPregunta8,
          borderColor: colorPalette[7].border,
          backgroundColor: colorPalette[7].background,
          fill: true,
        },
        {
          label: 'Manejo de Emociones Negativas',
          data: aciertosPregunta9,
          borderColor: colorPalette[8].border,
          backgroundColor: colorPalette[8].background,
          fill: true,
        },
        {
          label: 'Cumplimiento de Tareas Asignadas',
          data: aciertosPregunta10,
          borderColor: colorPalette[9].border,
          backgroundColor: colorPalette[9].background,
          fill: true,
        }
      ]
    },
    options: {
      responsive: true,
      plugins: {
        zoom: {
          zoom: {
            wheel: { enabled: true },
            pinch: { enabled: true },
            mode: 'x'
          },
          pan: { enabled: true, mode: 'x' }
        }
      },
      scales: {
        x: { title: { display: true, text: 'Mes/Año' } },
        y: { title: { display: true, text: 'Aciertos' } }
      }
    }
  });
}

// Inicialización de la gráfica de torta (pie chart) con porcentajes en tooltips y en labels
async function initPieChart() {
  const pieData = await fetchData('get_pieIndObs_data.php');
  if (!pieData) {
    console.error("No se pudieron obtener datos para la gráfica de torta.");
    return;
  }
  
  const pieLabels = pieData.map(item => item.test);
  const pieValues = pieData.map(item => item.total_aciertos);
  const totalAciertos = pieValues.reduce((acc, val) => acc + val, 0);
  
  const canvasPie = document.getElementById('pieChart');
  if (!canvasPie) {
    console.error('No se encontró el elemento canvas con id "pieChart".');
    return;
  }
  
  const ctxPie = canvasPie.getContext('2d');
  new Chart(ctxPie, {
    type: 'pie',
    data: {
      labels: pieLabels,
      datasets: [{
        data: pieValues,
        backgroundColor: [
          colorPalette[0].border,
          colorPalette[1].border,
          colorPalette[2].border,
          colorPalette[3].border,
          colorPalette[4].border,
          colorPalette[5].border,
          colorPalette[6].border,
          colorPalette[7].border,
          colorPalette[8].border,
          colorPalette[9].border
        ]
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'top' },
        tooltip: {
          callbacks: {
            label: function(context) {
              const label = context.label || '';
              const value = context.raw;
              const percentage = totalAciertos > 0 ? ((value / totalAciertos) * 100).toFixed(2) : 0;
              return `${label}: ${percentage}% (${value})`;
            }
          }
        },
        datalabels: {
          color: '#fff',
          formatter: function(value) {
            const percentage = totalAciertos > 0 ? ((value / totalAciertos) * 100).toFixed(2) : 0;
            return percentage + '%';
          }
        }
      }
    },
    plugins: [ChartDataLabels]
  });
}

window.onload = function() {
  initEvolutionChart();
  initPieChart();
};
