<?php
// archivo atencion_concentracion.php
include 'db_config.php';
include 'encabezado.php';

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluación de Atención y Concentración en el Aula de Clases</title>
    <style>
        .test-summary-container {
            border: 1px solid #ccc;
            padding: 20px;
            margin-top: 20px;
            border-radius: 10px;
            background-color: #f9f9f9;
        }
        .summary-title {
            font-size: 1.5em;
            margin-bottom: 10px;
        }
        .summary-box {
            font-size: 1em;
            line-height: 1.5;
        }
    </style>
</head>
<body>
    <h1>Evaluación de Atención y Concentración en el Aula de Clases</h1>

    <!-- Sección para configurar la evaluación -->
    <div id="setup-section">
        <form method="POST" action="save_results_atencion.php">
            <label for="participant_name">Nombre del Participante:</label>
            <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>
            <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" required>
            <br><br>

            <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
            <select id="modalidad_deporte" name="modalidad_deporte" required>
                <option value="ninguna">Ninguna</option>
                <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
                <option value="resistencia moderada">Resistencia moderada</option>
                <option value="aerobicos adaptados">Aeróbicos adaptados</option>
            </select>
            <br><br>

            <label for="atencion_concentracion">Seleccione el tiempo de atención y concentración en el aula:</label>
            <select id="atencion_concentracion" name="atencion_concentracion" required title="Seleccione el tiempo que logra el beneficiario mantener la concentración en una actividad en el aula de clase">
                <option value="">Selecciona</option>
                <option value="2">hasta 2 minutos</option>
                <option value="5">hasta 5 minutos</option>
                <option value="10">hasta 10 minutos</option>
                <option value="15">hasta 15 minutos</option>
                <option value="30">hasta 30 minutos</option>
                <option value="45">hasta 45 minutos</option>
            </select>
            <br><br>
            <!--button type="button" onclick="saveResults()">Guardar y Mostrar Resultados</button-->
            <button type="submit" id="submit" class="btn">Guardar y Mostrar Resultados</button>
        </form>
    </div>
</body>
</html>
