<?php
// Página principal de la aplicación móvil
// archivo atencion_concentracion3.php
include 'db_config.php';
include 'index3.php';

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluación de Atención y Concentración en el Aula de Clases</title>
    <!--script>
        function saveResults() {
            // Obtén los valores de los campos del formulario
            const participantName = document.getElementById('participant_name').value;
            const activityType = document.getElementById('modalidad_deporte').value;
            const attentionType = document.getElementById('atencion_concentracion').value;

            // Validación para asegurarse de que todos los campos tengan valores
            if (!participantName || !activityType || !attentionType) {
                alert('Por favor, completa todos los campos antes de guardar.');
                return;
            }

            // Enviar datos al servidor usando fetch
            fetch('save_results_atencion.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    participantName,
                    activityType,
                    attentionType
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Mostrar el resumen de resultados con el formato deseado
                    document.getElementById('setup-section').style.display = 'none';
                    document.getElementById('results-section').style.display = 'block';

                    document.getElementById('summary-participant-name').innerText = participantName;
                    document.getElementById('summary-activity-type').innerText = activityType;
                    document.getElementById('summary-score').innerText = attentionType;
                    document.getElementById('summary-recommendations').innerText = data.recommendations || 'Continúe trabajando para fortalecer sus habilidades cognitivas.';
                } else {
                    alert('Error al guardar los resultados: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Hubo un error al guardar los datos.');
            });
        }
        
    </script-->
    <style>
        .test-summary-container {
            border: 1px solid #ccc;
            padding: 20px;
            margin-top: 20px;
            border-radius: 10px;
            background-color: #f9f9f9;
        }
        .summary-title {
            font-size: 1.5em;
            margin-bottom: 10px;
        }
        .summary-box {
            font-size: 1em;
            line-height: 1.5;
        }
    </style>
</head>
<body>
    <h1>Evaluación de Atención y Concentración en el Aula de Clases</h1>

    <!-- Sección para configurar la evaluación -->
    <div id="setup-section">
        <form method="POST" action="save_results_atencion3.php">
            <label for="participant_name">Nombre del Participante:</label>
            <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>
            <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" required>
            <br><br>

            <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
            <select id="modalidad_deporte" name="modalidad_deporte" required>
                <option value="ninguna">Ninguna</option>
                <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
                <option value="resistencia moderada">Resistencia moderada</option>
                <option value="aerobicos adaptados">Aeróbicos adaptados</option>
            </select>
            <br><br>

            <label for="atencion_concentracion">Seleccione el tiempo de atención y concentración en el aula:</label>
            <select id="atencion_concentracion" name="atencion_concentracion" required title="Seleccione el tiempo que logra el beneficiario mantener la concentración en una actividad en el aula de clase">
                <option value="">Selecciona</option>
                <option value="2">< a 2 minutos</option>
                <option value="5">< a 5 minutos</option>
                <option value="10">< a 10 minutos</option>
                <option value="15">< a 15 minutos</option>
            </select>
            <br><br>
            <!--button type="button" onclick="saveResults()">Guardar y Mostrar Resultados</button-->
            <button type="submit" id="submit" class="btn">Guardar y Mostrar Resultados</button>
        </form>
    </div>

    <!-- Sección de resultados -->
    <!--div id="results-section" style="display: none;">
        <div class="test-summary-container">
            <h3 class="summary-title">Resumen del Test de Atención y Concentración</h3>
            <div class="summary-box">
                <p><strong>Nombre del participante:</strong> <span id="summary-participant-name"></span></p>
                <p><strong>Modalidad de actividad física:</strong> <span id="summary-activity-type"></span></p>
                <p><strong>Tiempo de atención y concentración:</strong> <span id="summary-score"></span></p>
                <p><strong>Recomendaciones:</strong> <span id="summary-recommendations"></span></p>
            </div>
        </div>
    </div-->
</body>
</html>
