<?php
// archivo: atencion_velocidad_procesamiento3.php
include 'db_config.php';
include 'index3.php';
$participantName = isset($_GET['nombre']) ? $_GET['nombre'] : ''; // Obtener nombre del participante
$documentoIdentidad  = isset($_GET['id']) ? $_GET['id'] : ''; // Obtener número de identidad
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test de Atención y Velocidad de Procesamiento</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            text-align: center;
            padding: 20px;
        }
        h1 {
            color: #333;
        }
        #symbols-container, #numbers-container {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            flex-wrap: wrap;
        }
        .symbol, .number {
            width: 80px; /* Ajustado para mejor visibilidad */
            height: 80px;
            margin: 10px;
            background-color: #ddd;
            border: 2px solid #bbb;
            display: flex;
            justify-content: center;
            align-items: center;
            cursor: pointer;
        }
        .symbol img {
            max-width: 100%; /* Ajusta la imagen al contenedor */
            max-height: 100%;
        }
        #score-container {
            margin-top: 20px;
            font-size: 18px;
            font-weight: bold;
        }
        button {
            padding: 10px 20px;
            margin-top: 20px;
            background-color: #4CAF50;
            color: white;
            font-size: 18px;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        #recommendations {
            margin-top: 20px;
            font-size: 18px;
            color: #333;
        }
    </style>
</head>
<body>

    <header class="main-header">
    <h1>Test de Atención y Velocidad de Procesamiento</h1>
</header>
    <p>Empareja los símbolos con los números correspondientes. ¡Hazlo lo más rápido que puedas!</p>

    <div id="instructions">
        <p>Arrastra cada símbolo al número que corresponda.</p>
    </div>
    <div id="symbols-container"></div>
    <div id="numbers-container"></div>
    <p>Tiempo restante: <span id="timer">2:00</span></p>
    <p>Aciertos: <span id="correct-count">0</span></p>
    <button id="start-button">Comenzar prueba</button>

    <!-- Formulario con los campos de nombre, número de documento y modalidad de deporte -->
    <form action="backend_guardar_resultados3.php" method="post" onsubmit="prepareSubmission()">
        <input type="hidden" name="correctCount" id="correctCount" value="0">
        
        <!-- Campo para nombre del participante -->
        <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($participantName) ?>" required>

        <!-- Campo para número de documento -->
        <label for="id">Número de Identidad:</label>
        <input type="text" id="id" name="id" value="<?= htmlspecialchars($documentoIdentidad ) ?>" required>

        <!-- Campo para modalidad de actividad física -->
        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <select id="modalidad_deporte" name="modalidad_deporte">
            <option value="ninguna">Ninguna modalidad</option>
            <option value="baja intensidad y equilibrio">Ejercicios de baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Ejercicios de resistencia moderada</option>
            <option value="aerobicos adaptados">Ejercicios aeróbicos adaptados</option>
        </select><br><br>
        
        <input type="submit" value="Enviar Respuestas">
    </form>

    <div id="recommendations"></div>



    <script>
    let correctCount = 0;
    let timer;
    let timeRemaining = 120; 
    let isTestActive = false;

// Figuras y números disponibles
const fixedSymbols = ['triangle', 'square', 'circle', 'diamond', 'star']; // Figuras
const numbers = ['1', '2', '3', '4', '5']; // Números

// Función para mezclar un array aleatoriamente
function shuffleArray(array) {
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]]; // Intercambia elementos
    }
}

// Iniciar test cuando el usuario haga clic en el botón "Comenzar prueba"
document.getElementById('start-button').addEventListener('click', function () {
    startTest();
});

function startTest() {
    if (isTestActive) return;
    correctCount = 0;
    isTestActive = true;
    timeRemaining = 120;
    document.getElementById('correct-count').textContent = correctCount;
    document.getElementById('timer').textContent = formatTime(timeRemaining);
    startTimer();
    enableDragAndDrop();
}

function startTimer() {
    timer = setInterval(() => {
        if (timeRemaining <= 0) {
            clearInterval(timer);
            isTestActive = false;
            alert("¡Tiempo terminado! Finaliza la prueba.");
            showRecommendations();
        } else {
            timeRemaining--;
            document.getElementById('timer').textContent = formatTime(timeRemaining);
        }
    }, 1000);
}

function formatTime(seconds) {
    const minutes = Math.floor(seconds / 60);
    const remainingSeconds = seconds % 60;
    return `${minutes}:${remainingSeconds.toString().padStart(2, '0')}`;
}

function prepareSubmission() {
    document.getElementById('correctCount').value = correctCount;
}

function enableDragAndDrop() {
    const symbolsContainer = document.getElementById('symbols-container');
    const numbersContainer = document.getElementById('numbers-container');
    symbolsContainer.innerHTML = '';
    numbersContainer.innerHTML = '';

    // Mezclar símbolos y números de forma independiente
    let shuffledSymbols = [...fixedSymbols];
    let shuffledNumbers = [...numbers];
    shuffleArray(shuffledSymbols);
    shuffleArray(shuffledNumbers);

    // Crear mapeo aleatorio entre símbolos y números
    let randomPairs = [];
    for (let i = 0; i < shuffledSymbols.length; i++) {
        randomPairs.push({ symbol: shuffledSymbols[i], number: shuffledNumbers[i] });
    }
    
    // Mezclar las parejas para que la relación símbolo-número sea completamente aleatoria
    shuffleArray(randomPairs);

    // Generar las figuras de forma aleatoria
    randomPairs.forEach((pair) => {
        const symbolDiv = document.createElement('div');
        symbolDiv.classList.add('symbol');
        symbolDiv.draggable = true;
        symbolDiv.dataset.match = pair.number; // Asignamos el número correcto
        symbolDiv.innerHTML = `<img src="assets/symbols/${pair.symbol}.png" alt="${pair.symbol}">`;
        symbolDiv.addEventListener('dragstart', (e) => e.dataTransfer.setData('text', pair.number));
        symbolsContainer.appendChild(symbolDiv);
    });

    // Mostrar los números de manera aleatoria en diferentes posiciones
    shuffleArray(shuffledNumbers);
    shuffledNumbers.forEach((number) => {
        const numberDiv = document.createElement('div');
        numberDiv.classList.add('number');
        numberDiv.textContent = number;
        numberDiv.addEventListener('dragover', (e) => e.preventDefault());
        numberDiv.addEventListener('drop', (e) => {
            e.preventDefault();
            const draggedSymbolNumber = e.dataTransfer.getData('text');
            if (draggedSymbolNumber === number) { // Verifica si el número arrastrado es correcto
                correctCount++;
                updateScore();
                numberDiv.style.pointerEvents = "none";
                numberDiv.textContent += " ✓";
                showRecommendations(); // Mostrar recomendaciones dinámicamente
            }
        });
        numbersContainer.appendChild(numberDiv);
    });
}

function updateScore() {
    document.getElementById('correct-count').textContent = correctCount;
}

   function showRecommendations() {
    const recommendations = document.getElementById('recommendations');
    const modalidadDeporte = document.getElementById('modalidad_deporte').value.toLowerCase(); // Convertir a minúsculas para evitar errores
    let message = '';

    if (modalidadDeporte === 'ninguna') {
        if (correctCount < 3) {
            message = `Intenta mejorar tus tiempos con más ejercicios cognitivos.`;
        } else if (correctCount >= 3 && correctCount <= 4) {
            message = `Vas por buen camino, pero podrías obtener aún mejores resultados.`;
        } else {
            message = `¡Excelente trabajo! Aun así, incluir actividad física en tu día a día podría potenciar aún más tus habilidades cognitivas.`;
        }
    } else {
        if (correctCount < 3) {
            message = `Intenta mejorar tus tiempos con más ejercicios cognitivos. La actividad física que realizas es un buen complemento, sigue así.`;
        } else if (correctCount >= 3 && correctCount <= 4) {
            message = `Bien hecho, estás en el camino correcto. Continúa con actividades que estimulen tu mente y aprovecha tu modalidad deportiva para reforzar tu rendimiento.`;
        } else {
            message = `¡Excelente trabajo! Tu combinación de ejercicios cognitivos y actividad física está funcionando muy bien para tu salud mental.`;
        }
    }

    recommendations.textContent = message;
}
    </script>
</body>
</html>
