<?php
// archivo: backend_guardar_resultados3.php
include 'db_config.php';
include 'index3.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $correctCount = intval($_POST['correctCount']);
    $participantName = $_POST['participant_name'];
    $modalidadDeporte = $_POST['modalidad_deporte'];
    $documentoIdentidad = $_POST['id'];

    // Verificar si ya existe un registro previo
    $queryCheck = "SELECT * FROM atencion_velocidad_procesamiento WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1";
    $stmtCheck = $conn->prepare($queryCheck);
    $stmtCheck->bind_param("s", $documentoIdentidad);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();
    $isFollowUp = $resultCheck->num_rows > 0;

    $description = '';
    $recommendation = '';
    if ($isFollowUp) {
        // Comparación con el test anterior
        $lastEntry = $resultCheck->fetch_assoc();
        if ($correctCount > $lastEntry['aciertos']) {
            $description = "Comparativamente con el test anterior de Atención y velocidad de Procesamiento de información, hubo una mejoría.";
        } elseif ($correctCount < $lastEntry['aciertos']) {
            $description = "Comparativamente con el test anterior de Atención y velocidad de Procesamiento de información, hubo una disminución en el puntaje.";
        } else {
            $description = "Comparativamente con el test anterior de Atención y velocidad de Procesamiento de información, los resultados permanecieron iguales.";
        }
    } else {
        $description = "El resultado obtenido en el test inicial de atención y velocidad de procesamiento fue $correctCount aciertos.";
    }

    // Generar recomendaciones solo si hay modalidad de deporte
    if ($modalidadDeporte !== 'ninguna') {
    $correctCount ==  "?";
    if ($correctCount < 3) {
        $recommendation = "Mejora necesaria, Se sugiere fuertemente poner mucho empeño con miras a mejorar estas habilidades cognitivas evaluadas en el test. practicando ejercicios específicos relacionados con tu modalidad de deporte: $modalidadDeporte para mejorar tu rendimiento.";
        if ($correctCount < 4) {
            $recommendation = " Continúa trabajando para fortalecer tus habilidades cognitivas. Puedes integrar ejercicios específicos relacionados con tu modalidad de deporte: $modalidadDeporte.";
        }
    } else {
        $recommendation = "¡Felicitaciones! Su desempeño demuestra un excelente trabajo relacionados con tu modalidad de deporte: $modalidadDeporte, lo que se refleja en sus habilidades artísticas sobresalientes.";
    } 
    }

if ($modalidadDeporte == 'ninguna') {
    $correctCount ==  "?";
    if ($correctCount < 3) {
        $recommendation = "Mejora necesaria, Se sugiere fuertemente poner mucho empeño con miras a mejorar estas habilidades cognitivas evaluadas en el test.";
    } elseif ($correctCount < 4) {
        $recommendation = "Continúe trabajando para fortalecer sus habilidades artisticas.";
    } else {
        $recommendation = "¡Felicitaciones! Su desempeño demuestra un excelente trabajo, lo que se refleja en sus habilidades artísticas sobresalientes.";
    }
} 


    // Insertar el nuevo resultado en la base de datos
    $query = "INSERT INTO atencion_velocidad_procesamiento (participant_name, participant_id, aciertos, modalidad_deporte, resultado, recomendaciones) 
              VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssisss", $participantName, $documentoIdentidad, $correctCount, $modalidadDeporte, $description, $recommendation);

    if ($stmt->execute()) {
        echo json_encode([]); //"success" => true, "message" => "Datos guardados correctamente."
    } else {
        echo json_encode(["success" => false, "message" => "Error al guardar los datos."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Acceso no permitido."]);
}

?>  

<!-- Resumen del test para el usuario -->
<div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Atención y velocidad de Procesamiento de información</h3>
    <div class="summary-box">
        <p><strong>Nombre del participante:</strong> <?= htmlspecialchars($participantName) ?></p>
        <p><strong>Modalidad de Deporte:</strong> <?= htmlspecialchars($modalidadDeporte) ?></p>
        <p><strong>Puntaje obtenido:</strong> <?= $correctCount ?> aciertos</p>
        <p><strong>Resultados:</strong> <?= htmlspecialchars($description) ?></p>
        <p><strong>Recomendaciones:</strong> <?= htmlspecialchars($recommendation) ?></p>
    </div>
</div>
<?php
include "styleres.css";
?>