<?php 
// archivo bienestar_motivación.php
include 'db_config.php'; 
include "encabezado.php" ;
// Obtener el nombre del participante desde el parámetro GET
$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$participant_id = htmlspecialchars($_GET['id'] ?? '');

// Verificar si el participante ya ha diligenciado el test
$stmt = $conn->prepare("SELECT modalidad_deporte, bienestar_pre, motivacion_pre FROM cuestionarios_satisfaccion WHERE participant_name = ? AND participant_id = ? LIMIT 1");
$stmt->bind_param("ss", $nombreParticipante, $participant_id);
$stmt->execute();
$result = $stmt->get_result();
$participante = $result->fetch_assoc();
//$participante_id = $result->fetch_assoc();

// Determinar qué formulario mostrar
if (!$participante) {
    $mostrarTestInicial = true;
    $mostrarTestSeguimiento = false;
} else {
    $mostrarTestInicial = false;
    $mostrarTestSeguimiento = true;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Cuestionario de Bienestar</title>
</head>
<body>
    <h1>Cuestionario de Bienestar y Motivación</h1>
    <form action="save_bienestar_motivacion.php" method="POST" enctype="multipart/form-data">
       <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>

        <label for="participant_id">Número de Documento:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($participant_id) ?>" readonly>

        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <select id="modalidad_deporte" name="modalidad_deporte" required>
            <option value="ninguna" <?= isset($participante['modalidad_deporte']) && $participante['modalidad_deporte'] == 'ninguna' ? 'selected' : '' ?>>Ninguna</option>
            <option value="baja intensidad y equilibrio" <?= isset($participante['modalidad_deporte']) && $participante['modalidad_deporte'] == 'baja intensidad y equilibrio' ? 'selected' : '' ?>>Baja intensidad y equilibrio</option>
            <option value="resistencia moderada" <?= isset($participante['modalidad_deporte']) && $participante['modalidad_deporte'] == 'resistencia moderada' ? 'selected' : '' ?>>Resistencia moderada</option>
            <option value="aerobicos adaptados" <?= isset($participante['modalidad_deporte']) && $participante['modalidad_deporte'] == 'aerobicos adaptados' ? 'selected' : '' ?>>Aeróbicos adaptados</option>
        </select>
        <br><br>

        <?php if ($mostrarTestInicial): ?>
            <h2>Evaluación Inicial</h2>
            <label for="bienestar_pre">Nivel de Bienestar (1-10):</label>
            <input type="number" id="bienestar_pre" name="bienestar_pre" min="1" max="10" required title="Selecciona un numero entre el 1 y 10 segun tu persepción subjetiva de bienestar, 1 indica ningun bienestar , 10 indica máximo bienestar">
            <label for="motivacion_pre">Nivel de Motivación (1-10):</label>
            <input type="number" id="motivacion_pre" name="motivacion_pre" min="1" max="10" required title="Selecciona un numero entre el 1 y 10 segun tu persepción subjetiva de motivación, 1 indica ninguna motivación , 10 indica máxima motivación">
        <?php endif; ?>

        <?php if ($mostrarTestSeguimiento): ?>
            <h2>Evaluación de Seguimiento</h2>
            <label for="bienestar_post">Nivel de Bienestar (1-10):</label>
            <input type="number" id="bienestar_post" name="bienestar_post" min="1" max="10" required title="Selecciona un numero entre el 1 y 10 segun tu persepción subjetiva de bienestar, 1 indica ningun bienestar , 10 indica máximo bienestar">
            <label for="motivacion_post">Nivel de Motivación (1-10):</label>
            <input type="number" id="motivacion_post" name="motivacion_post" min="1" max="10" required title="Selecciona un numero entre el 1 y 10 segun tu persepción subjetiva de motivación, 1 indica ninguna motivación , 10 indica máxima motivación">
        <?php endif; ?>
        <br><br>
        <button type="submit">Guardar Cuestionario</button>
    </form>
</body>
</html>
