<?php
// certificado_afiliacion.php

include 'db_config.php';  // Archivo de conexión a la base de datos
include 'encabezado2.php';  // Encabezado o menús, si los tiene

// Consulta para obtener la lista de beneficiarios
$sql_beneficiarios = "SELECT * FROM beneficiarios";
$result_beneficiarios = $conn->query($sql_beneficiarios);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Beneficiarios para Certificado de Afiliación</title>
    <style>
        .beneficiario-container {
            margin-bottom: 20px;
            border: 1px solid #ccc;
            padding: 10px;
            width: 300px;
            display: inline-block;
            vertical-align: top;
            margin-right: 20px;
        }
        .beneficiario-photo {
            max-width: 150px;
            height: 150px;
        }
        .tarifa-input {
            width: 100%;
            padding: 8px;
            margin-top: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .tarifa-submit {
            margin-top: 10px;
            background-color: #4CAF50;
            color: white;
            padding: 10px;
            border: none;
            cursor: pointer;
        }
        .tarifa-submit:hover {
            background-color: #45a049;
        }
        .readonly-input {
            background-color: #f1f1f1;
            border: none;
            color: #555;
        }
    </style>
</head>
<body>
    <h1>Lista de Beneficiarios - Generar Certificado de Afiliación</h1><br>
    <h2>Ingrese la tarifa mensual y verifique la institución patrocinadora antes de generar el certificado en formato PDF</h2>

    <?php
    if ($result_beneficiarios->num_rows > 0) {
        while ($beneficiario = $result_beneficiarios->fetch_assoc()) {
            ?>
            <div class="beneficiario-container">
                <!-- Fotografía del beneficiario -->
                <?php
                $photo_path = "uploads/fotos/" . $beneficiario['fotografia'];
                if (!empty($beneficiario['fotografia']) && file_exists($photo_path)) {
                    echo "<img src='$photo_path' alt='Foto de {$beneficiario['nombre_completo']}' class='beneficiario-photo'>";
                } else {
                    echo "<p>No hay fotografía disponible.</p>";
                }
                ?>

                <!-- Nombre del beneficiario -->
                <h2><?php echo htmlspecialchars($beneficiario['nombre_completo']); ?></h2>

                <!-- Documento de identidad del beneficiario -->
                <p>Documento de Identidad: <?php echo htmlspecialchars($beneficiario['documento_identidad']); ?></p>

                <!-- Formulario para ingresar la tarifa mensual y generar el certificado -->
                <form action="generate_certificado_afiliacion.php" method="POST" target="_blank">
                    <input type="hidden" name="beneficiario_id" value="<?php echo $beneficiario['id']; ?>">

                    <!-- Mostrar el nombre de la institución patrocinadora -->
                    <label for="institucion_<?php echo $beneficiario['id']; ?>">Institución Patrocinadora:</label>
                    <input type="text" id="institucion_<?php echo $beneficiario['id']; ?>" name="institucion_patrocinadora" class="tarifa-input readonly-input" value="<?php echo htmlspecialchars($beneficiario['institucion_patrocinadora']); ?>" readonly>

                    <!-- Campo para ingresar la tarifa mensual -->
                    <label for="tarifa_<?php echo $beneficiario['id']; ?>">Tarifa Mensual (en $):</label>
                    <input type="number" step="0.01" id="tarifa_<?php echo $beneficiario['id']; ?>" name="tarifa_mensual" class="tarifa-input" required placeholder="Ingrese la tarifa mensual">

                    <button type="submit" class="tarifa-submit">Generar Certificado PDF</button>
                </form>
            </div>
            <?php
        }
    } else {
        echo "<p>No hay beneficiarios registrados.</p>";
    }
    ?>
</body>
</html>

<?php
$conn->close();
?>
