<?php
// archivo comprension_lectora3.php

// Incluir archivos necesarios
include 'db_config.php';
include 'index3.php';

// Capturar datos desde los parámetros GET
$participant_name = htmlspecialchars($_GET['nombre'] ?? '');
$participant_id = htmlspecialchars($_GET['id'] ?? '');

// Lista de textos y preguntas
$texts = [
    [
        "text" => "Juan salió temprano de casa para ir a la escuela. En el camino encontró a un perro perdido y decidió llevarlo con él.",
        "questions" => [
            "¿A dónde iba Juan?" => ["A la escuela", "Al mercado", "A la casa de un amigo", "Al cine"],
            "¿Qué encontró Juan en el camino?" => ["Un perro perdido", "Un gato perdido", "Un niño perdido", "Un objeto perdido"],
            "¿Qué decidió hacer Juan con el perro?" => ["Llevarlo con él", "Ignorarlo", "Devolverlo a su dueño", "Llevarlo al veterinario"]
        ]
    ],
    [
        "text" => "María compró ingredientes frescos para preparar una cena especial. Invitó a sus amigos a disfrutar de una noche agradable.",
        "questions" => [
            "¿Qué compró María?" => ["Ingredientes frescos", "Electrodomésticos", "Ropa nueva", "Flores"],
            "¿Para qué preparó una cena especial?" => ["Para una noche agradable", "Para un cumpleaños", "Para una reunión familiar", "Para una celebración"],
            "¿A quién invitó María?" => ["A sus amigos", "A sus vecinos", "A su familia", "A sus compañeros de trabajo"]
        ]
    ],
    [
        "text" => "Carlos estudió toda la noche para su examen de matemáticas. Al día siguiente, se sintió seguro y logró obtener una excelente calificación.",
        "questions" => [
            "¿Qué hizo Carlos durante la noche?" => ["Estudió", "Dormió", "Jugó videojuegos", "Leyó una novela"],
            "¿Para qué estaba estudiando?" => ["Un examen de matemáticas", "Una exposición", "Una reunión", "Una entrevista"],
            "¿Cómo se sintió Carlos al día siguiente?" => ["Seguro", "Preocupado", "Cansado", "Nervioso"]
        ]
    ],
    [
        "text" => "Luisa adoptó un gato pequeño de un refugio. Lo llamó Max y le preparó un lugar cómodo para que durmiera.",
        "questions" => [
            "¿Qué adoptó Luisa?" => ["Un gato", "Un perro", "Un pájaro", "Un pez"],
            "¿De dónde lo adoptó?" => ["De un refugio", "De una tienda", "De un amigo", "De la calle"],
            "¿Qué nombre le puso al gato?" => ["Max", "Luna", "Simba", "Milo"]
        ]
    ],
    [
        "text" => "El sábado, Pedro y su hermana fueron al parque. Jugaron con la pelota y disfrutaron de un picnic bajo los árboles.",
        "questions" => [
            "¿A dónde fueron Pedro y su hermana?" => ["Al parque", "A la playa", "Al cine", "A la montaña"],
            "¿Qué hicieron en el parque?" => ["Jugaron con la pelota", "Corrieron", "Montaron bicicleta", "Levantaron cometas"],
            "¿Dónde disfrutaron el picnic?" => ["Bajo los árboles", "En la banca", "Cerca de un lago", "En una colina"]
        ]
    ],
    [
        "text" => "Ana leyó un libro sobre aventuras en el espacio. Imaginó cómo sería viajar a otros planetas.",
        "questions" => [
            "¿Qué estaba leyendo Ana?" => ["Un libro sobre aventuras en el espacio", "Un cuento de hadas", "Un libro de historia", "Una novela romántica"],
            "¿Qué imaginó Ana?" => ["Viajar a otros planetas", "Ser astronauta", "Construir una nave", "Ser famosa"],
            "¿De qué trataba el libro?" => ["Aventuras en el espacio", "Historias de animales", "Viajes en el tiempo", "Exploraciones submarinas"]
        ]
    ],
    [
        "text" => "Martín plantó flores en el jardín de su casa. Cada día las regaba y pronto vio cómo crecían hermosas y coloridas.",
        "questions" => [
            "¿Qué plantó Martín?" => ["Flores", "Árboles", "Vegetales", "Hierbas"],
            "¿Dónde las plantó?" => ["En el jardín de su casa", "En un parque", "En una maceta", "En un bosque"],
            "¿Qué hacía Martín todos los días?" => ["Regarlas", "Cortarlas", "Podarlas", "Tomar fotos"]
        ]
    ],
    [
        "text" => "El autobús estaba lleno de pasajeros cuando comenzó a llover. Todos miraron por la ventana las gotas que caían rápidamente.",
        "questions" => [
            "¿Qué pasó mientras estaban en el autobús?" => ["Comenzó a llover", "Hubo un accidente", "El conductor se detuvo", "Llegaron a su destino"],
            "¿Qué miraban los pasajeros?" => ["Las gotas de lluvia", "El paisaje", "El conductor", "El reloj"],
            "¿Cómo estaba el autobús?" => ["Lleno de pasajeros", "Vacío", "Con pocos pasajeros", "En reparación"]
        ]
    ],
    [
        "text" => "Laura aprendió a montar bicicleta con la ayuda de su padre. Al principio tenía miedo, pero después logró pedalear sola.",
        "questions" => [
            "¿Qué aprendió Laura?" => ["A montar bicicleta", "A nadar", "A leer", "A bailar"],
            "¿Quién la ayudó?" => ["Su padre", "Su madre", "Su hermana", "Su abuelo"],
            "¿Cómo se sintió al principio?" => ["Con miedo", "Feliz", "Triste", "Impaciente"]
        ]
    ],
    [
        "text" => "En el cumpleaños de Pablo, todos cantaron, comieron pastel y jugaron juegos divertidos en el patio.",
        "questions" => [
            "¿De quién era el cumpleaños?" => ["De Pablo", "De Ana", "De Luis", "De Carla"],
            "¿Qué comieron?" => ["Pastel", "Helado", "Pizza", "Sandwiches"],
            "¿Dónde jugaron juegos?" => ["En el patio", "En el parque", "En la sala", "En el jardín"]
        ]
    ],
    [
        "text" => "El río estaba tranquilo y los peces nadaban cerca de la orilla. Un grupo de niños se sentó a observarlos.",
        "questions" => [
            "¿Cómo estaba el río?" => ["Tranquilo", "Agitado", "Congelado", "Sucio"],
            "¿Qué hacían los peces?" => ["Nadaban cerca de la orilla", "Saltaban", "Se escondían", "Comían"],
            "¿Qué hizo el grupo de niños?" => ["Se sentó a observarlos", "Nadó", "Pescó", "Construyó un bote"]
        ]
    ],
    [
        "text" => "Sofía decidió aprender a cocinar su plato favorito. Después de varios intentos, logró prepararlo perfectamente.",
        "questions" => [
            "¿Qué decidió hacer Sofía?" => ["Aprender a cocinar", "Salir a comer", "Estudiar una receta", "Comprar un libro de cocina"],
            "¿Qué logró después de varios intentos?" => ["Prepararlo perfectamente", "Hacer una sopa", "Cocinar para otros", "Hornear un pastel"],
            "¿Qué estaba aprendiendo?" => ["Su plato favorito", "Un postre", "Un desayuno", "Una cena especial"]
        ]
    ]
];

// Selección aleatoria de texto y preguntas
$selected_text_key = array_rand($texts);
$selected_text = $texts[$selected_text_key];

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluación de Comprensión Lectora</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <section>
        <h1>Evaluación de Comprensión Lectora</h1>
        <form method="POST" action="save_result_comprension_lectora3.php">
          
                <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($participant_name) ?>" readonly>

                <label for="participant_id">Número de Documento:</label>
                <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($participant_id) ?>" readonly>

                <label for="modalidad_deporte">Modalidad de Actividad Física:</label><br>
        <select id="modalidad_deporte" name="modalidad_deporte">
            <option value="ninguna ">Ninguna modalidad</option>
            <option value="baja intensidad y equilibrio">Ejercicios de baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Ejercicios de resistencia moderada</option>
            <option value="aerobicos adaptados">Ejercicios aeróbicos adaptados</option>
        </select><br><br>

       <h3> Lee con atención el texto a continuación y responde a las preguntas</h3> <br><br>
              
<p><?php echo $selected_text['text']; ?></p><br><br>

<!-- Campo oculto para enviar el índice del texto seleccionado -->
            <input type="hidden" name="text_index" value="<?= $selected_text_key ?>">

<fieldset>
                <legend>Preguntas</legend>
                <?php foreach ($selected_text['questions'] as $question => $options): ?>
                    <p><?= $question; ?></p>
                    <?php 
                        // Guardar la respuesta correcta (el primer elemento del arreglo original)
                        $correct = $options[0];
                    ?>
                    <input type="hidden" name="correct_answers[<?= htmlspecialchars($question) ?>]" value="<?= htmlspecialchars($correct) ?>">
                    <?php 
                        // Mezclar las opciones para mostrarlas de forma aleatoria
                        $shuffled_options = $options;
                        shuffle($shuffled_options);
                    ?>
                    <?php foreach ($shuffled_options as $option): ?>
                        <label>
                            <input type="radio" name="answers[<?= htmlspecialchars($question) ?>]" value="<?= htmlspecialchars($option) ?>" required>
                            <?= $option; ?>
                        </label><br>
                    <?php endforeach; ?>
                <?php endforeach; ?>
            </fieldset>
            <br>
            <button type="submit">Enviar Respuestas</button>
        </form><br><br><br>
    </section>
</body>
</html>
