<?php
// Configuración de la base de datos
$host = 'localhost';
$db = 'proyect5_sistema_beneficiarios';
$user = 'proyect5';
$pass = 'U[Y-1407eLjuTe';

/*$db = 'sistema_beneficiarios';
$user = 'root';
$pass = '';*/

// Crear conexión
$conn = new mysqli($host, $user, $pass, $db);

// Verificar la conexión
if ($conn->connect_error) {
    die("Error en la conexión: " . $conn->connect_error);
}

// Establecer la codificación de caracteres
$conn->set_charset("utf8");

//echo "Conexión exitosa a la base de datos";

// Establecer el conjunto de caracteres utf8mb4 para admitir caracteres especiales
$conn->set_charset("utf8mb4");

// Crear la base de datos si no existe, asegurando que use utf8mb4
$sql = "CREATE DATABASE IF NOT EXISTS $db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
if ($conn->query($sql) === TRUE) {
    echo " "; //Base de datos creada o ya existente.<br>
} else {
    die("Error al crear la base de datos: " . $conn->error);
}

// Seleccionar la base de datos
$conn->select_db($db);


// Crear la tabla 'usarios' si no existe, con soporte para caracteres especiales
    $table_usarios = "CREATE TABLE IF NOT EXISTS usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(50) NOT NULL,
    clave VARCHAR(255) NOT NULL,
    tipo_usuario INT NOT NULL COMMENT '1 = Admin, 2 = Usuario Regular, 3 = Usuario Temporal',
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP

)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_usarios) === TRUE) {
    echo " "; //Tabla 'usarios' creada o ya existente.<br> 
} else {
    die("Error al crear la tabla 'usarios': " . $conn->error);
}



// Crear la tabla 'beneficiarios' si no existe, con soporte para caracteres especiales
$table_beneficiarios = "CREATE TABLE IF NOT EXISTS beneficiarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre_completo VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    documento_identidad VARCHAR(20) NOT NULL UNIQUE,
    fecha_nacimiento DATE NOT NULL,
    correo_electronico VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    acudiente VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    institucion_patrocinadora VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    grupo VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    programa VARCHAR (250) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad VARCHAR (250) COLLATE utf8mb4_unicode_ci NOT NULL,
    antiguedad VARCHAR (250) COLLATE utf8mb4_unicode_ci NOT NULL,
    sede VARCHAR (150) COLLATE utf8mb4_unicode_ci NOT NULL,
    areas VARCHAR (250) COLLATE utf8mb4_unicode_ci NOT NULL,
    investigacion VARCHAR (250) COLLATE utf8mb4_unicode_ci NOT NULL,
    profesionales VARCHAR (250) COLLATE utf8mb4_unicode_ci NOT NULL,
    fotografia VARCHAR(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    diagnosis VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP

) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_beneficiarios) === TRUE) {
    echo " "; //Tabla 'beneficiarios' creada o ya existente.<br> 
} else {
    die("Error al crear la tabla 'beneficiarios': " . $conn->error);
}

// Crear la tabla 'seguimientos' si no existe, con soporte para caracteres especiales
$table_seguimientos = "CREATE TABLE IF NOT EXISTS seguimientos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    beneficiario_id INT NOT NULL,
    evaluador VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    asignatura VARCHAR(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_evaluacion DATE NOT NULL,
    apreciacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    objetivos TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    ajustes_razonables TEXT COLLATE utf8mb4_unicode_ci,
    plan_accion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    periodicidad VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    desarrollo_cognitivo TEXT COLLATE utf8mb4_unicode_ci,
    habilidades_sociales TEXT COLLATE utf8mb4_unicode_ci,
    autonomia TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    desempeño_academico TEXT COLLATE utf8mb4_unicode_ci NULL,
    competencia_lectoescritura TEXT COLLATE utf8mb4_unicode_ci NULL,
    matematica_basica TEXT COLLATE utf8mb4_unicode_ci NULL,
    habilidades_organizacionales TEXT COLLATE utf8mb4_unicode_ci NULL,
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NULL, 
    observaciones TEXT COLLATE utf8mb4_unicode_ci NULL,
    FOREIGN KEY (beneficiario_id) REFERENCES beneficiarios(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_seguimientos) === TRUE) {
    echo " "; //Tabla 'seguimientos' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'seguimientos': " . $conn->error);
}

// Tabla para almacenar datos del test de Memoria.
$table_test_entries = "CREATE TABLE IF NOT EXISTS test_entries (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,  -- Nuevo campo para ID del participante
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    aciertos INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Se cambia a TEXT COLLATE utf8mb4_unicode_ci NOT NULL para comentarios más largos
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Se cambia a TEXT COLLATE utf8mb4_unicode_ci NOT NULL para recomendaciones más largas
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_test_entries) === TRUE) {
    echo " "; //Tabla 'test_entries' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'test_entries': " . $conn->error);
}

// Tabla para almacenar datos del test de funciones ejecutivas
$table_funciones_ejecutivas = "CREATE TABLE IF NOT EXISTS funciones_ejecutivas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    aciertos INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para las recomendaciones
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_funciones_ejecutivas) === TRUE) {
    echo " "; //Tabla 'funciones_ejecutivas' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'funciones_ejecutivas': " . $conn->error);
}


// Tabla para almacenar datos del test de atencion y velocidad de procesamiento de la informacion
$table_atencion_velocidad_procesamiento ="CREATE TABLE IF NOT EXISTS atencion_velocidad_procesamiento (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    aciertos INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_atencion_velocidad_procesamiento) === TRUE) {
    echo " "; //Tabla 'atencion_velocidad_procesamiento' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'atencion_velocidad_procesamiento': " . $conn->error);
}

// Tabla para almacenar datos del test visioespacial
$table_visuoespacial_results ="CREATE TABLE IF NOT EXISTS visuoespacial_results (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    aciertos INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_visuoespacial_results) === TRUE) {
    echo " "; //Tabla 'visuoespacial_results' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'visuoespacial_results': " . $conn->error);
}

// Tabla para almacenar datos del test de lectura y comprensión
$table_lectura_comprensión="CREATE TABLE IF NOT EXISTS lectura_comprensión (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    score INT NOT NULL,
    lectura TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    comprension TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para las recomendaciones
    progreso TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_lectura_comprensión) === TRUE) {
    echo " "; //Tabla 'lectura_comprensión' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'lectura_comprensión': " . $conn->error);
}

// Tabla para almacenar datos del test escritura
$table_escritura ="CREATE TABLE IF NOT EXISTS escritura (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    score INT NOT NULL,
    escritura INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para las recomendaciones
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_escritura) === TRUE) {
    echo " "; //Tabla 'escritura' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'escritura': " . $conn->error);
}

// Tabla para almacenar datos del test matematicas basicas
$table_matematicas_basicas ="CREATE TABLE IF NOT EXISTS matematicas_basicas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    tipo_operacion VARCHAR(50) NOT NULL,
    score INT NOT NULL,
    total_preguntas INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para las recomendaciones
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_matematicas_basicas) === TRUE) {
    echo " "; //Tabla 'matematicas_basicas' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'matematicas_basicas': " . $conn->error);
}

// Tabla para almacenar datos del test matencion y concentracion
$table_atencion_concentracion ="CREATE TABLE IF NOT EXISTS atencion_concentracion (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    aciertos INT NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_atencion_concentracion) === TRUE) {
    echo " "; //Tabla 'atencion_concentracion' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'atencion_concentracion': " . $conn->error);
}

// Tabla para almacenar datos del test resolución de problemas
$table_resolucion_problemas ="CREATE TABLE IF NOT EXISTS resolucion_problemas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    categoria VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    dificultad VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    aciertos INT NOT NULL,
    preguntasSeleccionadas INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendaciones TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para las recomendaciones
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_resolucion_problemas) === TRUE) {
    echo " "; //Tabla 'resolucion_problemas' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'resolucion_problemas': " . $conn->error);
}


// Tabla para almacenar las preguntas del test resolución de problemas
$table_preguntas ="CREATE TABLE IF NOT EXISTS preguntas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    pregunta TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    categoria VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    dificultad VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    respuesta_correcta TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    opciones JSON NOT NULL,
fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_preguntas) === TRUE) {
    echo " "; //Tabla 'preguntas' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'preguntas': " . $conn->error);
}

// Insertar preguntas si no están ya insertadas
$check_preguntas = "SELECT COUNT(*) AS total FROM preguntas";
$result_check = $conn->query($check_preguntas);
$row_check = $result_check->fetch_assoc();

if ($row_check['total'] == 0) {
    $preguntas = [
        'matematicas' => [
            'facil' => [
        ["text" => "¿Cuánto es 2 + 2?", "answer" => 4, "options" => [4, 5, 3, 6]],
        ["text" => "¿Cuál es el doble de 5?", "answer" => 10, "options" => [10, 15, 20, 5]],
        ["text" => "¿Cuánto es 10 - 3?", "answer" => 7, "options" => [7, 6, 8, 5]],
        ["text" => "¿Cuánto es 5 + 4?", "answer" => 9, "options" => [9, 8, 10, 7]],
        ["text" => "¿Cuánto es 6 - 1?", "answer" => 5, "options" => [5, 4, 6, 7]],
        ["text" => "¿Cuánto es 3 + 3?", "answer" => 6, "options" => [6, 9, 3, 12]],
        ["text" => "¿Cuál es el triple de 2?", "answer" => 6, "options" => [6, 8, 4, 10]],
        ["text" => "¿Cuánto es 8 - 5?", "answer" => 3, "options" => [3, 2, 4, 5]],
        ["text" => "¿Cuánto es 4 + 1?", "answer" => 5, "options" => [5, 6, 4, 7]],
        ["text" => "¿Cuánto es 7 - 2?", "answer" => 5, "options" => [5, 4, 6, 8]]
    ],
    'medio' => [
        ["text" => "¿Cuánto es 12 x 2?", "answer" => 24, "options" => [24, 22, 26, 30]],
        ["text" => "¿Cuál es el cuadrado de 5?", "answer" => 25, "options" => [25, 20, 30, 35]],
        ["text" => "¿Cuánto es 50 / 5?", "answer" => 10, "options" => [10, 12, 8, 15]],
        ["text" => "¿Cuánto es 7 x 6?", "answer" => 42, "options" => [42, 48, 36, 40]],
        ["text" => "¿Cuánto es 15 + 35?", "answer" => 50, "options" => [50, 45, 55, 60]],
        ["text" => "¿Cuánto es 20 x 3?", "answer" => 60, "options" => [60, 50, 70, 80]],
        ["text" => "¿Cuánto es 100 / 4?", "answer" => 25, "options" => [25, 20, 30, 40]],
        ["text" => "¿Cuánto es 9 x 8?", "answer" => 72, "options" => [72, 64, 81, 56]],
        ["text" => "¿Cuánto es 14 x 3?", "answer" => 42, "options" => [42, 39, 45, 36]],
        ["text" => "¿Cuánto es 81 / 9?", "answer" => 9, "options" => [9, 8, 10, 7]]
    ],
    'dificil' => [
        ["text" => "¿Cuánto es 123 + 456?", "answer" => 579, "options" => [579, 578, 580, 570]],
        ["text" => "¿Cuánto es 789 - 123?", "answer" => 666, "options" => [666, 665, 667, 660]],
        ["text" => "¿Cuál es el cubo de 3?", "answer" => 27, "options" => [27, 26, 28, 25]],
        ["text" => "¿Cuánto es 12 x 12?", "answer" => 144, "options" => [144, 142, 146, 140]],
        ["text" => "¿Cuánto es 144 / 12?", "answer" => 12, "options" => [12, 11, 13, 14]],
        ["text" => "¿Cuánto es 25 x 16?", "answer" => 400, "options" => [400, 380, 420, 440]],
        ["text" => "¿Cuánto es 1024 / 16?", "answer" => 64, "options" => [64, 63, 65, 60]],
        ["text" => "¿Cuál es la raíz cuadrada de 169?", "answer" => 13, "options" => [13, 12, 14, 15]],
        ["text" => "¿Cuánto es 11 x 11?", "answer" => 121, "options" => [121, 120, 122, 110]],
        ["text" => "¿Cuánto es 99 + 101?", "answer" => 200, "options" => [200, 199, 201, 210]]
    ]
],
'logica' => [
    'facil' => [
        ["text" => "Si hoy es lunes, ¿qué día será pasado mañana?", "answer" => "miércoles", "options" => ["miércoles", "martes", "jueves", "domingo"]],
        ["text" => "Si tienes 5 manzanas y das 2, ¿cuántas te quedan?", "answer" => 3, "options" => [3, 4, 2, 5]],
        ["text" => "¿Qué número sigue en la secuencia: 2, 4, 6, ...?", "answer" => 8, "options" => [8, 7, 10, 6]],
        ["text" => "¿Cuál es el opuesto de frío?", "answer" => "calor", "options" => ["calor", "hielo", "tibio", "frío"]],
        ["text" => "Si Ana tiene 3 perros y Pedro tiene 2, ¿quién tiene más?", "answer" => "Ana", "options" => ["Ana", "Pedro", "igual", "ninguno"]],
        ["text" => "¿Cuántos lados tiene un triángulo?", "answer" => 3, "options" => [3, 4, 5, 6]],
        ["text" => "Si tienes 10 caramelos y comes 4, ¿cuántos quedan?", "answer" => 6, "options" => [6, 5, 4, 7]],
        ["text" => "¿Qué número falta en la secuencia: 5, 10, 15, ...?", "answer" => 20, "options" => [20, 25, 15, 30]],
        ["text" => "¿Cuál es el siguiente día después del viernes?", "answer" => "sábado", "options" => ["sábado", "domingo", "lunes", "viernes"]],
        ["text" => "¿Cuántas patas tiene un gato?", "answer" => 4, "options" => [4, 3, 5, 6]]
    ],
    'medio' => [
        ["text" => "¿Qué número sigue en la secuencia: 1, 1, 2, 3, 5, ...?", "answer" => 8, "options" => [8, 7, 10, 6]],
        ["text" => "Si 5 x 3 = 15 y 15 x 2 = 30, ¿cuánto es 30 / 5?", "answer" => 6, "options" => [6, 5, 7, 8]],
        ["text" => "¿Qué forma geométrica tiene 4 lados iguales?", "answer" => "cuadrado", "options" => ["cuadrado", "triángulo", "círculo", "rectángulo"]],
        ["text" => "Si un tren viaja a 100 km/h, ¿cuántos km recorre en 3 horas?", "answer" => 300, "options" => [300, 200, 400, 500]],
        ["text" => "Si 2 + 2 = 4, ¿cuánto es 4 x 4?", "answer" => 16, "options" => [16, 12, 18, 14]],
        ["text" => "Si A > B y B > C, ¿cuál es la relación entre A y C?", "answer" => "A > C", "options" => ["A > C", "A < C", "A = C", "A ≠ C"]],
        ["text" => "¿Cuál es el siguiente número primo después del 7?", "answer" => 11, "options" => [11, 9, 13, 17]],
        ["text" => "¿Cuántos segundos hay en 2 minutos?", "answer" => 120, "options" => [120, 100, 150, 90]],
        ["text" => "Si giras 90 grados a la derecha, ¿en qué dirección estás?", "answer" => "este", "options" => ["este", "norte", "sur", "oeste"]],
        ["text" => "¿Qué día de la semana sigue después del domingo?", "answer" => "lunes", "options" => ["lunes", "martes", "miércoles", "domingo"]]
    ],
    'dificil' => [
        ["text" => "Si un reloj marca las 3:15, ¿cuántos grados hay entre las manecillas?", "answer" => 97.5, "options" => [97.5, 90, 105, 85]],
        ["text" => "¿Cuántas caras tiene un icosaedro?", "answer" => 20, "options" => [20, 18, 12, 24]],
        ["text" => "Si un número es divisible por 6 y 9, ¿por qué número también es divisible?", "answer" => 18, "options" => [18, 12, 15, 20]],
        ["text" => "Si una escalera tiene 15 escalones y subes 3 a la vez, ¿cuántos pasos das?", "answer" => 5, "options" => [5, 4, 6, 7]],
        ["text" => "Si un coche viaja 120 km a 80 km/h, ¿cuánto tiempo tarda?", "answer" => 1.5, "options" => [1.5, 1, 2, 2.5]],
        ["text" => "¿Qué número sigue en la secuencia: 2, 4, 8, 16, ...?", "answer" => 32, "options" => [32, 28, 24, 48]],
        ["text" => "Si un ángulo mide 45 grados, ¿cuánto mide su complementario?", "answer" => 45, "options" => [45, 55, 30, 60]],
        ["text" => "Si tienes 3 monedas y juntas 4 veces su valor, ¿cuánto tienes?", "answer" => 12, "options" => [12, 9, 10, 15]],
        ["text" => "¿Cuántos lados tiene un dodecágono?", "answer" => 12, "options" => [12, 10, 14, 16]],
        ["text" => "¿Cuál es el resultado de 1000 / (10 + 5)?", "answer" => 66.67, "options" => [66.67, 60, 75, 80]]
    ]
],
'ciencias' => [
    'facil' => [
        ["text" => "¿Cómo se llama el planeta más cercano al sol?", "answer" => "Mercurio", "options" => ["Mercurio", "Venus", "Marte", "Júpiter"]],
        ["text" => "¿De qué están hechas las estrellas?", "answer" => "gases", "options" => ["gases", "agua", "polvo", "rocas"]],
        ["text" => "¿Cómo se llama el satélite natural de la Tierra?", "answer" => "Luna", "options" => ["Luna", "Sol", "Marte", "Júpiter"]],
        ["text" => "¿Cuántos planetas tiene nuestro sistema solar?", "answer" => 8, "options" => [8, 9, 10, 7]],
        ["text" => "¿Qué elemento químico tiene como símbolo O?", "answer" => "Oxígeno", "options" => ["Oxígeno", "Oro", "Osmio", "Ocelote"]],
        ["text" => "¿Qué necesitamos para respirar?", "answer" => "Oxígeno", "options" => ["Oxígeno", "Agua", "Carbono", "Nitrógeno"]],
        ["text" => "¿De qué color es el cielo durante el día?", "answer" => "Azul", "options" => ["Azul", "Rojo", "Verde", "Amarillo"]],
        ["text" => "¿Qué animal pone huevos?", "answer" => "Pájaro", "options" => ["Pájaro", "Perro", "Gato", "Caballo"]],
        ["text" => "¿Qué planeta es conocido...", "answer" => "Marte", "options" => ["Marte", "Venus", "Saturno", "Neptuno"]]
    ],
    'medio' => [
        ["text" => "¿Cuál es la fórmula química del agua?", "answer" => "H2O", "options" => ["H2O", "CO2", "O2", "H2SO4"]],
        ["text" => "¿Cuántos huesos tiene el cuerpo humano?", "answer" => 206, "options" => [206, 208, 210, 220]],
        ["text" => "¿Cuál es la fuente principal de energía para los seres vivos?", "answer" => "El sol", "options" => ["El sol", "La luna", "El aire", "El agua"]],
        ["text" => "¿Qué gas es responsable del cambio climático?", "answer" => "Dióxido de carbono", "options" => ["Dióxido de carbono", "Oxígeno", "Nitrógeno", "Metano"]],
        ["text" => "¿Cómo se llama el proceso por el cual las plantas producen su alimento?", "answer" => "Fotosíntesis", "options" => ["Fotosíntesis", "Respiración", "Evaporación", "Digestión"]],
        ["text" => "¿Qué causa la lluvia?", "answer" => "La condensación", "options" => ["La condensación", "La evaporación", "La fotosíntesis", "La combustión"]],
        ["text" => "¿Cómo se llama el gas que las plantas absorben del aire para hacer fotosíntesis?", "answer" => "Dióxido de carbono", "options" => ["Dióxido de carbono", "Oxígeno", "Nitrógeno", "Metano"]],
        ["text" => "¿Qué animal es conocido por su capacidad de cambiar de color?", "answer" => "Camaleón", "options" => ["Camaleón", "León", "Elefante", "Tigre"]],
        ["text" => "¿Cuántos continentes hay en el mundo?", "answer" => 7, "options" => [7, 6, 5, 8]],
        ["text" => "¿Qué se necesita para formar una nube?", "answer" => "Vapor de agua", "options" => ["Vapor de agua", "Gases", "Tierra", "Luz"]]
    ],
    'dificil' => [
        ["text" => "¿Cuál es la teoría que explica el origen del universo?", "answer" => "Big Bang", "options" => ["Big Bang", "Teoría de la evolución", "Teoría heliocéntrica", "Teoría cuántica"]],
        ["text" => "¿Cuántos cromosomas tiene un ser humano?", "answer" => 46, "options" => [46, 48, 44, 42]],
        ["text" => "¿Cuál es el órgano más grande del cuerpo humano?", "answer" => "La piel", "options" => ["La piel", "El corazón", "El cerebro", "El hígado"]],
        ["text" => "¿Qué es la teoría de la relatividad?", "answer" => "La teoría que describe la gravedad como la curvatura del espacio-tiempo", "options" => ["La teoría que describe la gravedad como la curvatura del espacio-tiempo", "La teoría sobre la evolución de las especies", "La teoría cuántica", "La teoría de la mecánica clásica"]],
        ["text" => "¿Qué tipo de célula no tiene núcleo?", "answer" => "Células procariotas", "options" => ["Células procariotas", "Células eucariotas", "Células animales", "Células vegetales"]],
        ["text" => "¿Qué es un agujero negro?", "answer" => "Una región del espacio donde la gravedad es tan fuerte que nada puede escapar", "options" => ["Una región del espacio donde la gravedad es tan fuerte que nada puede escapar", "Un planeta lejano", "Una estrella en explosión", "Una nube de gas en el espacio"]],
        ["text" => "¿Qué fenómeno físico se produce cuando los rayos de luz se desvían al pasar por una superficie?", "answer" => "Refracción", "options" => ["Refracción", "Reflexión", "Absorción", "Difracción"]],
        ["text" => "¿Qué tipo de energía produce el sol?", "answer" => "Energía nuclear", "options" => ["Energía nuclear", "Energía eléctrica", "Energía solar", "Energía cinética"]],
        ["text" => "¿Cuál es la principal fuente de energía para los seres humanos?", "answer" => "Glucosa", "options" => ["Glucosa", "Oxígeno", "Ácido láctico", "Fructosa"]],
        ["text" => "¿Qué es la fuerza gravitatoria?", "answer" => "La fuerza que atrae a los objetos hacia el centro de la Tierra", "options" => ["La fuerza que atrae a los objetos hacia el centro de la Tierra", "La fuerza que empuja los objetos hacia el espacio", "La fuerza que da forma a los planetas", "La fuerza que mantiene las estrellas en su lugar"]]
    ]
] 

];

    // Recorremos cada categoría y subcategoría
    foreach ($preguntas as $categoria => $dificultades) {
        foreach ($dificultades as $dificultad => $items) {
            foreach ($items as $pregunta) {
                // Preparamos las opciones como JSON
                $opciones_json = json_encode($pregunta['options'], JSON_UNESCAPED_UNICODE);
                
                // Realizamos la inserción de las preguntas en la base de datos
                $stmt = $conn->prepare("INSERT INTO preguntas (pregunta, categoria, dificultad, respuesta_correcta, opciones) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("sssss", $pregunta['text'], $categoria, $dificultad, $pregunta['answer'], $opciones_json);
                
                if ($stmt->execute()) {
                    echo "Pregunta insertada: " . $pregunta['text'] . "<br>";
                } else {
                    echo "Error al insertar la pregunta: " . $stmt->error . "<br>";
                }
            }
        }
    }
} else {
    echo ""; //Las preguntas ya están insertadas.<br>
}

// Tabla para almacenar datos del test de retención
$table_resultados_retencion ="CREATE TABLE IF NOT EXISTS resultados_retencion (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) NOT NULL,
    aciertos INT NOT NULL,
    recomendacion VARCHAR(255) NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_resultados_retencion) === TRUE) {
    echo " "; //Tabla 'resultados_retencion' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'resultados_retencion': " . $conn->error);
}


// Tabla para almacenar 12 lecturas y sus cuestionarios para el test de retención
$table_lecturas_retencion ="CREATE TABLE IF NOT EXISTS lecturas_retencion (
    id INT AUTO_INCREMENT PRIMARY KEY,
    titulo VARCHAR(255) NULL,
    contenido TEXT COLLATE utf8mb4_unicode_ci NULL,
    pregunta1 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta1_correcta VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta1_distractor1 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta1_distractor2 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta1_distractor3 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    pregunta2 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta2_correcta VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta2_distractor1 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta2_distractor2 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta2_distractor3 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    pregunta3 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta3_correcta VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta3_distractor1 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta3_distractor2 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta3_distractor3 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    pregunta4 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta4_correcta VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta4_distractor1 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta4_distractor2 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta4_distractor3 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    pregunta5 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta5_correcta VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta5_distractor1 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta5_distractor2 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    respuesta5_distractor3 VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_lecturas_retencion) === TRUE) {
    echo " "; //Tabla 'lecturas_retencion' creada correctamente o ya existente.<br>";
} else {
    die("Error al crear la tabla 'lecturas_retencion': " . $conn->error);
}

// Insertar lecturas y preguntas si no están ya insertadas
$check_lecturas = "SELECT COUNT(*) AS total FROM lecturas_retencion";
$result_check = $conn->query($check_lecturas);
$row_check = $result_check->fetch_assoc();

if ($row_check['total'] == 0) {
    $insert_lecturas = "
INSERT INTO lecturas_retencion (titulo, contenido,
    pregunta1, respuesta1_correcta, respuesta1_distractor1, respuesta1_distractor2, respuesta1_distractor3,
    pregunta2, respuesta2_correcta, respuesta2_distractor1, respuesta2_distractor2, respuesta2_distractor3,
    pregunta3, respuesta3_correcta, respuesta3_distractor1, respuesta3_distractor2, respuesta3_distractor3,
    pregunta4, respuesta4_correcta, respuesta4_distractor1, respuesta4_distractor2, respuesta4_distractor3,
    pregunta5, respuesta5_correcta, respuesta5_distractor1, respuesta5_distractor2, respuesta5_distractor3)
VALUES
    -- Lectura 1
('El Ciclo del Agua',
 'El ciclo del agua describe cómo el agua se mueve a través de la Tierra. Este proceso incluye la evaporación del agua en los océanos, la formación de nubes por condensación y la precipitación en forma de lluvia o nieve...',
 '¿Qué proceso convierte el agua en vapor?', 'La evaporación', 'La condensación', 'La precipitación', 'La sublimación',
 '¿Qué se forma después de la condensación?', 'Las nubes', 'La lluvia', 'El hielo', 'El vapor de agua',
 '¿Cómo regresa el agua a la Tierra?', 'Por la precipitación', 'Por la condensación', 'Por la evaporación', 'Por la transpiración',
 '¿Qué nombre tiene el ciclo completo del agua?', 'El ciclo hidrológico', 'El ciclo geológico', 'El ciclo atmosférico', 'El ciclo terrestre',
 '¿Dónde ocurre mayormente la evaporación?', 'En los océanos', 'En los ríos', 'En los lagos', 'En las montañas'),

-- Lectura 2
('La Fotosíntesis',
 'La fotosíntesis es el proceso mediante el cual las plantas convierten la luz solar, el dióxido de carbono y el agua en energía. Este proceso produce oxígeno como subproducto, esencial para la vida en la Tierra...',
 '¿Qué gas toman las plantas para la fotosíntesis?', 'Dióxido de carbono', 'Oxígeno', 'Nitrógeno', 'Hidrógeno',
 '¿Qué producen las plantas durante la fotosíntesis?', 'Oxígeno', 'Dióxido de carbono', 'Azúcares', 'Agua',
 '¿Qué necesitan las plantas para realizar la fotosíntesis?', 'Luz solar, agua y dióxido de carbono', 'Nutrientes y oxígeno', 'Luz ultravioleta y nitrógeno', 'Agua y minerales',
 '¿Qué tipo de energía convierten las plantas?', 'Energía solar en energía química', 'Energía térmica en energía eléctrica', 'Energía cinética en energía química', 'Energía lumínica en energía térmica',
 '¿Dónde ocurre la fotosíntesis en la planta?', 'En las hojas', 'En las raíces', 'En el tallo', 'En las flores'),

-- Lectura 3
('Los Volcanes',
 'Un volcán es una abertura en la corteza terrestre por donde escapan magma, gases y cenizas. Los volcanes activos pueden ser peligrosos, pero también forman nuevas tierras y enriquecen el suelo con nutrientes...',
 '¿Qué material sale de un volcán?', 'Magma', 'Lava solidificada', 'Rocas sedimentarias', 'Cenizas compactas',
 '¿Cómo se llaman los volcanes que no han hecho erupción recientemente?', 'Volcanes inactivos', 'Volcanes extintos', 'Volcanes dormidos', 'Volcanes emergentes',
 '¿Qué beneficio tienen los volcanes para el suelo?', 'Enriquecen el suelo con nutrientes', 'Forman lagos', 'Absorben dióxido de carbono', 'Generan energía térmica',
 '¿Qué tipo de roca se forma del magma enfriado?', 'Roca ígnea', 'Roca metamórfica', 'Roca sedimentaria', 'Roca volcánica',
 '¿Qué tipo de volcán es el más peligroso?', 'El volcán activo', 'El volcán extinto', 'El volcán inactivo', 'El volcán submarino'),

-- Lectura 4
('La Energía Renovable',
 'La energía renovable proviene de recursos naturales como el sol, el viento y el agua, que se regeneran con el tiempo. Estas fuentes son limpias y ayudan a reducir el impacto ambiental causado por los combustibles fósiles...',
 '¿Qué es una fuente de energía renovable?', 'El sol, el viento y el agua', 'El carbón y el petróleo', 'El gas natural', 'El uranio',
 '¿Qué ventaja tiene la energía renovable?', 'Es limpia y reduce el impacto ambiental', 'Es económica y rápida de producir', 'Es más abundante que otras energías', 'Es la más eficiente',
 '¿Qué recurso utiliza la energía eólica?', 'El viento', 'El sol', 'El agua', 'El calor del subsuelo',
 '¿Qué tipo de energía proviene del sol?', 'La energía solar', 'La energía térmica', 'La energía hidráulica', 'La energía nuclear',
 '¿Por qué es importante la energía renovable?', 'Porque se regenera y protege el medio ambiente', 'Porque es más económica', 'Porque no produce desechos', 'Porque es la más accesible'),

-- Lectura 5
('El Sistema Solar',
 'El sistema solar está compuesto por el sol, los planetas y otros cuerpos celestes como asteroides y cometas. Cada planeta tiene características únicas, y todos giran alrededor del sol debido a su gravedad...',
 '¿Qué objeto está en el centro del sistema solar?', 'El sol', 'La Tierra', 'Júpiter', 'La Luna',
 '¿Qué mantiene a los planetas en órbita?', 'La gravedad', 'La rotación', 'La presión', 'La energía solar',
 '¿Qué cuerpos celestes, además de planetas, forman parte del sistema solar?', 'Asteroides y cometas', 'Estrellas y galaxias', 'Nebulosas y agujeros negros', 'Lunas y satélites artificiales',
 '¿Qué planeta es conocido como el planeta rojo?', 'Marte', 'Venus', 'Saturno', 'Mercurio',
 '¿Cuántos planetas hay en el sistema solar?', 'Ocho', 'Nueve', 'Siete', 'Diez'),



-- Lectura 6
('El Reino Animal',
 'El reino animal se divide en dos grupos principales: los vertebrados, que tienen columna vertebral, y los invertebrados, que no la tienen. Los vertebrados incluyen mamíferos, aves, reptiles, anfibios y peces...',
 '¿Cuántos tipos principales de animales existen?', 'Dos: vertebrados e invertebrados', 'Mamíferos y reptiles', 'Terrestres y acuáticos', 'Animales de sangre caliente y sangre fría',
 '¿Qué grupo de animales tiene columna vertebral?', 'Los vertebrados', 'Los invertebrados', 'Los mamíferos', 'Los reptiles',
 '¿Qué animal pertenece al grupo de los mamíferos?', 'El perro', 'El pez', 'El pájaro', 'El reptil',
 '¿Qué tipo de animales son los insectos?', 'Invertebrados', 'Vertebrados', 'Mamíferos', 'Acuáticos',
 '¿Qué diferencia a los vertebrados de los invertebrados?', 'Los vertebrados tienen columna vertebral', 'Los invertebrados son más grandes', 'Los vertebrados viven en tierra', 'Los invertebrados tienen huesos'),

-- Lectura 7
('El Transporte Urbano',
 'El transporte urbano se refiere al sistema de movilidad que permite a las personas desplazarse dentro de una ciudad. Incluye autobuses, trenes, bicicletas y otros medios de transporte...',
 '¿Qué objetivo tiene el transporte urbano?', 'Reducir el tráfico y ahorrar tiempo', 'Promover el turismo', 'Incrementar el número de vehículos', 'Eliminar el transporte público',
 '¿Qué medio de transporte es más común en las grandes ciudades?', 'El autobús', 'La bicicleta', 'El avión', 'El coche particular',
 '¿Qué beneficio tiene el uso de bicicletas en la ciudad?', 'Reduce la contaminación', 'Aumenta el tráfico', 'Es más caro', 'Provoca más accidentes',
 '¿Qué tipo de transporte es más eficiente en ciudades congestionadas?', 'El transporte público', 'El automóvil privado', 'El transporte aéreo', 'Las motocicletas',
 '¿Qué se busca con el uso del transporte público?', 'Reducir la contaminación y el tráfico', 'Aumentar el consumo de combustible', 'Reducir la velocidad', 'Fomentar el uso de coches privados'),

-- Lectura 8
('La Alimentación Saludable',
 'Una alimentación saludable consiste en consumir una variedad de alimentos en las proporciones adecuadas. Esto incluye frutas, verduras, proteínas magras y carbohidratos integrales... ',
 '¿Qué alimentos forman parte de una dieta saludable?', 'Frutas, verduras y proteínas magras', 'Alimentos fritos y procesados', 'Carbohidratos y azúcares refinados', 'Bebidas energéticas y gaseosas',
 '¿Qué es importante en una dieta saludable?', 'El equilibrio y la variedad', 'Comer solo alimentos bajos en calorías', 'Evitar los carbohidratos completamente', 'Consumir solo alimentos orgánicos',
 '¿Qué tipo de alimentos deben consumirse con moderación?', 'Alimentos altos en grasas y azúcares', 'Verduras', 'Frutas', 'Proteínas magras',
 '¿Qué grupo de alimentos ayuda a la reparación de los tejidos del cuerpo?', 'Las proteínas', 'Los carbohidratos', 'Las grasas', 'Los azúcares',
 '¿Qué beneficio aporta una dieta equilibrada?', 'Mejora la salud y el bienestar', 'Aumenta el peso corporal', 'Reduce la energía', 'Causa enfermedades'),

-- Lectura 9
('El Clima y el Tiempo',
 'El clima se refiere a las condiciones atmosféricas promedio a largo plazo, mientras que el tiempo se refiere a las condiciones momentáneas que se experimentan en un lugar... ',
 '¿Qué diferencia al clima del tiempo?', 'El tiempo es momentáneo y el clima es a largo plazo', 'Ambos son fenómenos diarios', 'El clima no influye en el tiempo', 'El tiempo solo se mide en años',
 '¿Qué afecta principalmente al clima de una región?', 'La temperatura y la humedad', 'El viento', 'La altitud', 'La actividad volcánica',
 '¿Qué instrumento se utiliza para medir la temperatura?', 'El termómetro', 'El barómetro', 'El anemómetro', 'El higrómetro',
 '¿Qué es la humedad?', 'La cantidad de vapor de agua en el aire', 'La cantidad de lluvia que cae', 'La velocidad del viento', 'La presión atmosférica',
 '¿En qué consiste el pronóstico del tiempo?', 'Predecir las condiciones atmosféricas a corto plazo', 'Analizar las condiciones del clima a largo plazo', 'Medir la temperatura a largo plazo', 'Estimar la cantidad de energía solar'),

-- Lectura 10
('La Cadena Alimenticia',
 'La cadena alimenticia es el proceso mediante el cual los seres vivos se alimentan unos de otros. Los productores son los organismos que producen su propio alimento, como las plantas... ',
 '¿Qué inicia una cadena alimenticia?', 'Los productores', 'Los consumidores primarios', 'Los descomponedores', 'Los herbívoros',
 '¿Qué tipo de organismos son los productores?', 'Las plantas', 'Los carnívoros', 'Los insectos', 'Los peces',
 '¿Qué organismo se encuentra en la parte final de la cadena alimenticia?', 'Los descomponedores', 'Los productores', 'Los consumidores primarios', 'Los herbívoros',
 '¿Qué ocurre cuando un organismo muere en la cadena alimenticia?', 'Los descomponedores lo descomponen', 'Es comido por un carnívoro', 'Se convierte en productor', 'No ocurre nada',
 '¿Qué es un consumidor primario?', 'Un organismo que se alimenta de productores', 'Un organismo que se alimenta de otros consumidores', 'Un organismo que produce su propio alimento', 'Un organismo que descompone materia muerta'),

-- Lectura 11
('La Electricidad',
 'La electricidad es una forma de energía que resulta del movimiento de electrones en un conductor. Se utiliza para encender luces, operar electrodomésticos y en muchas otras aplicaciones... ',
 '¿Qué causa la electricidad?', 'El movimiento de electrones', 'La energía térmica', 'La fricción entre objetos', 'La fuerza gravitacional',
 '¿Cómo se genera la electricidad?', 'Por el movimiento de electrones a través de un conductor', 'Por la fricción entre materiales', 'Por la rotación de un generador', 'Por el paso de corrientes de aire',
 '¿Qué tipo de energía es la electricidad?', 'Energía cinética', 'Energía potencial', 'Energía térmica', 'Energía nuclear',
 '¿Qué aparato convierte la energía mecánica en energía eléctrica?', 'El generador', 'La batería', 'El electrodoméstico', 'El interruptor',
 '¿Cómo se transporta la electricidad?', 'A través de cables conductores', 'A través de ondas de radio', 'A través de tuberías', 'A través de luces LED'),

-- Lectura 12
('El Cuerpo Humano',
 'El cuerpo humano está compuesto por varios sistemas que trabajan en conjunto para mantenernos vivos. El sistema circulatorio transporta sangre, el sistema nervioso controla las funciones, y el sistema digestivo procesa los alimentos... ',
 '¿Qué sistema transporta la sangre?', 'El sistema circulatorio', 'El sistema nervioso', 'El sistema digestivo', 'El sistema óseo',
 '¿Qué sistema controla las funciones del cuerpo?', 'El sistema nervioso', 'El sistema muscular', 'El sistema óseo', 'El sistema respiratorio',
 '¿Cuál es la función principal del sistema digestivo?', 'Procesar los alimentos', 'Transportar oxígeno', 'Producir hormonas', 'Controlar el movimiento',
 '¿Qué órgano es fundamental en el sistema circulatorio?', 'El corazón', 'El cerebro', 'Los pulmones', 'El hígado',
 '¿Qué parte del cuerpo está involucrada en la respiración?', 'Los pulmones', 'El estómago', 'El cerebro', 'Los riñones');
";

if ($conn->query($insert_lecturas) === TRUE) {
        echo "Lecturas y preguntas insertadas correctamente.<br>";
    } else {
        die("Error al insertar lecturas: " . $conn->error);
    }
} else {
    echo "";//Las lecturas ya están insertadas.<br>";
}

// Tabla para almacenar datos del test de lectura retención mas simple
$table_lecturas_retencion_simple ="CREATE TABLE IF NOT EXISTS lecturas_retencion_simple (
    id SERIAL PRIMARY KEY,
    lectura TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    pregunta TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    respuesta_correcta TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    distractor_1 TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    distractor_2 TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    distractor_3 TEXT COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_lecturas_retencion_simple) === TRUE) {
    echo " "; //Tabla 'lecturas_retencion_simple' creada correctamente o ya existente.<br>";
} else {
    die("Error al crear la tabla 'lecturas_retencion_simple': " . $conn->error);
}

// Insertar lecturas y preguntas si no están ya insertadas
$check_lecturas_simples = "SELECT COUNT(*) AS total FROM lecturas_retencion_simple";
$result_check = $conn->query($check_lecturas_simples);
$row_check = $result_check->fetch_assoc();

if ($row_check['total'] == 0) {
    $insert_lecturas_simples = "

INSERT INTO lecturas_retencion_simple (lectura, pregunta, respuesta_correcta, distractor_1, distractor_2, distractor_3)
VALUES
    (
        'La capital de Francia es París, conocida por su arte, gastronomía y cultura histórica. La ciudad alberga la famosa Torre Eiffel, uno de los monumentos más icónicos del mundo.',
        '¿Cuál es la capital de Francia?',
        'París',
        'Londres',
        'Roma',
        'Berlín'
    ),
    (
        'El agua hierve a una temperatura de 100 grados Celsius al nivel del mar. Este punto de ebullición puede variar dependiendo de la altitud.',
        '¿A qué temperatura hierve el agua al nivel del mar?',
        '100 grados Celsius',
        '90 grados Celsius',
        '110 grados Celsius',
        '120 grados Celsius'
    ),
    (
        'La fotosíntesis es el proceso por el cual las plantas convierten la luz solar en energía química, utilizando dióxido de carbono y agua para producir glucosa y oxígeno.',
        '¿Qué producen las plantas durante la fotosíntesis?',
        'Glucosa y oxígeno',
        'Dióxido de carbono y agua',
        'Nitrógeno y glucosa',
        'Oxígeno y nitrógeno'
    ),
    (
        'La Gran Muralla China se extiende a lo largo de más de 13,000 millas y fue construida para proteger los estados y territorios chinos contra invasores y nómadas.',
        '¿Cuál es la longitud aproximada de la Gran Muralla China?',
        '13,000 millas',
        '10,000 millas',
        '15,000 millas',
        '8,000 millas'
    ),
    (
        'El cuerpo humano tiene 206 huesos en total, siendo el fémur el hueso más largo y fuerte.',
        '¿Cuántos huesos tiene el cuerpo humano?',
        '206',
        '200',
        '210',
        '215'
    );

    ";

if ($conn->query($insert_lecturas_simples) === TRUE) {
        echo "Lecturas y preguntas insertadas correctamente.<br>";
    } else {
        die("Error al insertar lecturas: " . $conn->error);
    }
} else {
    echo "";//Las lecturas ya están insertadas.<br>";
}

// Tabla para almacenar datos del test de artes dibujo y pintura
$table_dibujo_pintura ="CREATE TABLE IF NOT EXISTS dibujo_pintura (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
     puntaje_precision INT NOT NULL,
    puntaje_colores INT NOT NULL,
    puntaje_organizacion INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_dibujo_pintura) === TRUE) {
    echo " "; //Tabla 'dibujo_pintura' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'dibujo_pintura': " . $conn->error);
}

// Tabla para almacenar datos del test de artes escultura y modelado
$table_escultura_modelado ="CREATE TABLE IF NOT EXISTS escultura_modelado (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
     puntaje_destreza INT NOT NULL,
    puntaje_fuerza INT NOT NULL,
    puntaje_coordinacion INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_escultura_modelado) === TRUE) {
    echo " "; //Tabla 'escultura_modelado' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'escultura_modelado': " . $conn->error);
}


// Tabla para almacenar datos del test de artes Ritmo y Tempo
$table_ritmo_tempo ="CREATE TABLE IF NOT EXISTS ritmo_tempo (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
     puntaje_ritmo INT NOT NULL,
    puntaje_tempo INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_ritmo_tempo) === TRUE) {
    echo " "; //Tabla 'ritmo_tempo' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'ritmo_tempo': " . $conn->error);
}

// Tabla para almacenar datos del test de Danza y Expresión Corporal
$table_danza_expresion_corporal ="CREATE TABLE IF NOT EXISTS danza_expresion_corporal (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    puntaje_coordinacion INT NOT NULL,
    puntaje_equilibrio INT NOT NULL,
    puntaje_control_corporal INT NOT NULL,
    puntaje_espontaneidad INT NOT NULL,
    puntaje_creatividad INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_danza_expresion_corporal) === TRUE) {
    echo " "; //Tabla 'danza_expresion_corporal' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'danza_expresion_corporal': " . $conn->error);
}

// Tabla para almacenar datos del test de expresión teatral
$table_expresion_teatral ="CREATE TABLE IF NOT EXISTS expresion_teatral (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    puntaje_expresion INT NOT NULL,
    puntaje_proyectar_voz INT NOT NULL,
    puntaje_control_corporal INT NOT NULL,
    puntaje_modular_tonos INT NOT NULL,
    puntaje_articulacion INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_expresion_teatral) === TRUE) {
    echo " "; //Tabla 'expresion_teatral' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'expresion_teatral': " . $conn->error);
}


// Tabla para almacenar datos de satisfacción del usuario
$table_cuestionarios_satisfaccion ="CREATE TABLE IF NOT EXISTS cuestionarios_satisfaccion (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    bienestar_pre INT NOT NULL,
    bienestar_post INT NOT NULL,
    motivacion_pre INT NOT NULL,
    motivacion_post INT NOT NULL,
    resultado TEXT COLLATE utf8mb4_unicode_ci NOT NULL,  -- Campo para el resultado
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_cuestionarios_satisfaccion) === TRUE) {
    echo " "; //Tabla 'cuestionarios_satisfaccion' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'cuestionarios_satisfaccion': " . $conn->error);
}

// Tabla para almacenar datos de los logros auto persividos por el usuario
$table_logros ="CREATE TABLE IF NOT EXISTS logros (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    logro_academico TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    logro_personal TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_logros) === TRUE) {
    echo " "; //Tabla 'logros' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'logros': " . $conn->error);
}

// Tabla para almacenar datos del impacto persivido por el docente
$table_evaluacion_impacto ="CREATE TABLE IF NOT EXISTS evaluacion_impacto (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_name VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    participant_id VARCHAR(20) COLLATE utf8mb4_unicode_ci NOT NULL,
    modalidad_deporte VARCHAR(50) COLLATE utf8mb4_unicode_ci NOT NULL,
    pregunta1 INT NOT NULL,
    pregunta2 INT NOT NULL,
    pregunta3 INT NOT NULL,
    pregunta4 INT NOT NULL,
    pregunta5 INT NOT NULL,
    pregunta6 INT NOT NULL,
    pregunta7 INT NOT NULL,
    pregunta8 INT NOT NULL,
    pregunta9 INT NOT NULL,
    pregunta10 INT NOT NULL,
    promedio FLOAT NOT NULL,
    recomendacion TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($table_evaluacion_impacto) === TRUE) {
    echo " "; //Tabla 'evaluacion_impacto' creada o ya existente.<br>
} else {
    die("Error al crear la tabla 'evaluacion_impacto': " . $conn->error);
}

// Dejar la conexión abierta para otras operaciones si es necesario
?>
