'<?php
// archivo dibujo_pintura.php
include 'db_config.php';
include 'encabezado.php'; 

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Evaluación en Artes Visuales</title>
</head>
<body>
    <h1>Evaluación en Artes Visuales: Dibujo y Pintura</h1>
    <form action="save_result_dibujo_pintura.php" method="POST" enctype="multipart/form-data">
       <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>
        <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" required>

        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <select id="modalidad_deporte" name="modalidad_deporte" required>
            <option value="ninguna">Ninguna</option>
            <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Resistencia moderada</option>
            <option value="aerobicos adaptados">Aeróbicos adaptados</option>
        </select>
<br> <br>

        <h2>Escoge una imagen de tu preferencia dibujala y luego coloreala.</h2>
        <label for="puntaje_precision">Puntaje Precisión (1-10):</label>
        <input type="number" id="puntaje_precision" name="puntaje_precision" min="1" max="10" required>

        <label for="puntaje_colores">Puntaje Colores (1-10):</label>
        <input type="number" id="puntaje_colores" name="puntaje_colores" min="1" max="10" required>

        <label for="puntaje_organizacion">Puntaje Organización (1-10):</label>
        <input type="number" id="puntaje_organizacion" name="puntaje_organizacion" min="1" max="10" required><br>

        <button type="submit">Enviar Evaluación</button>
    </form>
</body>
</html>
