<?php
// editar_beneficiario.php
ob_start(); // Inicia el buffer de salida
include 'db_config.php';
include "encabezado.php";

// Verificar si se recibió un ID de beneficiario
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // Consultar los datos actuales del beneficiario
    $sql = "SELECT nombre_completo, documento_identidad, fecha_nacimiento, correo_electronico, acudiente, institucion_patrocinadora, programa, modalidad, antiguedad, areas, investigacion, profesionales, diagnosis, fotografia FROM beneficiarios WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $beneficiario = $result->fetch_assoc();
    } else {
        echo "Beneficiario no encontrado.";
        exit;
    }
}


?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Beneficiario</title>
</head>
<body>
    <h1>Editar Beneficiario</h1>
    <form action="editar_beneficiario.php?id=<?php echo $id; ?>" method="post" enctype="multipart/form-data">
        <label for="nombre_completo">Nombre Completo:<span class="error" style='color:red'>*</span></label>
        <input type="text" name="nombre_completo" value="<?php echo htmlspecialchars($beneficiario['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>" required title="Digite el nombre completo del alumno, tal y como aparece en su documento de identidad" size="35%"><br><br>

<label for="documento_identidad">Documento de Identidad:<span class="error" style='color:red'>*</span></label><br>
        <input type="number" id="documento_identidad" name="documento_identidad" value="<?php echo htmlspecialchars($beneficiario['documento_identidad'], ENT_QUOTES, 'UTF-8'); ?>" required title="Digite el número del documento de identidad del alumno, tal y como aparece en su documento de identidad"><br>
        
        <label for="fecha_nacimiento">Fecha de Nacimiento:<span class="error" style='color:red'>*</span></label><br>
        <input type="date" id="fecha_nacimiento" name="fecha_nacimiento" value="<?php echo htmlspecialchars($beneficiario['fecha_nacimiento'], ENT_QUOTES, 'UTF-8'); ?>" required title="Escoja la fecha de nacimiento del alumno, tal y como aparece en su documento de identidad"><br>
        
        <label for="correo_electronico">Correo Electrónico:</label><br>
        <input type="email" id="correo_electronico" name="correo_electronico" value="<?php echo htmlspecialchars($beneficiario['correo_electronico'], ENT_QUOTES, 'UTF-8'); ?>" required title="Digite el correo electrónico del acudiente o tutor del alumno" size="35%"><br>
        
        <label for="acudiente">Acudiente:<span class="error" style='color:red'>*</span></label><br>
        <input type="text" id="acudiente" name="acudiente" value="<?php echo htmlspecialchars($beneficiario['acudiente'], ENT_QUOTES, 'UTF-8'); ?>" required title="Digite el nombre completo del acudiente del alumno, tal y como aparece en su documento de identidad" size="35%"><br>
        
        <label for="institucion_patrocinadora">Institución Patrocinadora:<span class="error" style='color:red'>*</span></label><br>
        <select id="institucion_patrocinadora" name="institucion_patrocinadora" value="<?php echo htmlspecialchars($beneficiario['institucion_patrocinadora'], ENT_QUOTES, 'UTF-8'); ?>">
            <option value="ninguna">Ninguna</option>
            <option value="comfenalco">Comfenalco</option>
            <option value="comfama">Comfama</option>
        </select><br>    
    
        <label for="grupo">Grupo:<span class="error" style='color:red'>*</span></label><br>
        <select id="grupo" name="grupo" value="<?php echo htmlspecialchars($beneficiario['grupo'], ENT_QUOTES, 'UTF-8'); ?>">
            <option value="Semillitas 1">Semillitas 1</option>
            <option value="Semillitas 2">Semillitas 2</option>
            <option value="Semillitas 3">Semillitas 3</option>
            <option value="Semillitas 4">Semillitas 4</option>
            <option value="escaladores 1">Escaladores 1</option>
            <option value="escaladores 2">Escaladores 2</option>
            <option value="escaladores 3">Escaladores 3</option>
            <option value="escaladores 4">Escaladores 4</option>
            <option value="Pensantes 1">Pensantes 1</option>
            <option value="Pensantes 2">Pensantes 2</option>
            <option value="Pensantes 3">Pensantes 3</option>
            <option value="Pensantes 3">Pensantes 4</option>
            <option value="Integrados 1">Integrados 1</option>
            <option value="Integrados 2">Integrados 2</option>
            <option value="Integrados 3">Integrados 3</option>
            <option value="Integrados 4">Integrados 4</option>
        </select><br> 

        <label for="programa">Programa:<span class="error" style='color:red'>*</span></label><br>
        <input type="text" name="programa" id="programa" value="<?php echo htmlspecialchars($beneficiario['programa'], ENT_QUOTES, 'UTF-8'); ?>" required title="Digite Rehabilitación integral, desarrollo de habilidades u otro" size="65%"><br>

        <label for="modalidad">Modalidad de Atención:</label><br>
        <select id="modalidad" name="modalidad" value="<?php echo htmlspecialchars($beneficiario['modalidad'], ENT_QUOTES, 'UTF-8'); ?>">
            <option value="presencial">Presencial (total o alternancia)</option>
            <option value="virtual">Virtual</option>
            <option value="planes caseros">Planes caseros</option>
            <option value="otro">Otros</option>
        </select><br>

        <label for="sede">Sede:<span class="error" style='color:red'>*</span></label><br>
        <select id="sede" name="sede" value="<?php echo htmlspecialchars($beneficiario['sede'], ENT_QUOTES, 'UTF-8'); ?>">
            <option value="Medellín">Medellín</option>
            <option value="Bello">Bello</option>
            <option value="Otro Municipio">Otro Nunicipio</option>
        </select><br>

        <label for="antiguedad">Antigüedad:</label><br>
        <select id="antiguedad" name="antiguedad" value="<?php echo htmlspecialchars($beneficiario['antiguedad'], ENT_QUOTES, 'UTF-8'); ?>">
            <option value="antiguo(a)">Antiguo(a)</option>
            <option value="reingreso">Reingreso</option>
            <option value="nuevo este año">Nuevo este año</option>
        </select><br>

        <label for="areas">Disciplinas y Áreas de Atención:<span class="error" style='color:red'>*</span></label><br>
        <input type="text" name="areas" id="areas" value="<?php echo htmlspecialchars($beneficiario['areas'], ENT_QUOTES, 'UTF-8'); ?>" required title="Digite todas las materias o áreas en las que participa el beneficiario (música, artística, psicología, etc.)" size="65%"><br>
        
        <label for="investigacion">Participa en la investigación ?:</label><br>
        <select id="investigacion" name="investigacion" value="<?php echo htmlspecialchars($beneficiario['investigacion'], ENT_QUOTES, 'UTF-8'); ?>" title= "escoja SI si el acudiante o representante del beneficiario ya firmó el consentimiento informado" >
            <option value="si participa"> Si</option>
            <option value="no participa"> No</option>
            <option value="retiro del programa">Retiro de la investigación </option>
            <option value="retiro institucional"> Retiro de la institución</option>
        </select><br>

        <label for="profesionales">Profesionales que participan:<span class="error" style='color:red'>*</span></label><br>
        <input type="text" name="profesionales" id="profesionales" value="<?php echo htmlspecialchars($beneficiario['profesionales'], ENT_QUOTES, 'UTF-8'); ?>" required title="Digite el nombre de todos los profesionales responsables de cada área en la que participa el beneficiario" size="65%"><br>

         <label for="diagnosis">Diagnóstico (CIE 10, DSM-5, otros):<span class="error" style='color:red'>*</span></label><br>
<select id="diagnosis" name="diagnosis[]" multiple>
    <option value="No registrado">Ninguno</option>
                <!-- Diagnósticos comunes -->
                <option value="R.M leve">F70 - Retraso Mental Leve (50 a 69 de C.I.)</option>
<option value="R.M moderado">F71 - Retraso Mental Moderado (35 a 49 de C.I.)</option>
<option value="R.M grave">F72 - Retraso Mental Grave (20 a 34 de C.I.)</option>
<option value="R.M profundo">F73 - Retraso Mental Profundo (Menor a 20 de C.I.)</option>
<option value="otro R.M">F78 - Otro Retraso Mental</option>
<option value="R.M sin especificar">F79 - Retraso Mental sin especificación</option>
<option value="Trastorno específico del desarrollo del habla y del lenguaje expresivo">F80.0 - Trastorno específico del desarrollo del habla y del lenguaje expresivo</option>
<option value="Trastorno específico del desarrollo de la comprensión del lenguaje">F80.1 - Trastorno específico del desarrollo de la comprensión del lenguaje</option>
<option value="Trastorno de la adquisición de la producción del lenguaje">F80.2 - Trastorno de la adquisición de la producción del lenguaje (trastorno del habla)</option>
<option value="Trastorno del desarrollo del habla y del lenguaje, sin especificación">F80.9 - Trastorno del desarrollo del habla y del lenguaje, sin especificación</option>
<option value="Dislexia">F81.0 - Trastorno específico de la lectura (dislexia)</option>
<option value="Disortografia">F81.1 - Trastorno específico de la ortografía</option>
<option value="Discalculia">F81.2 - Trastorno específico del cálculo (discalculia)</option>
<option value="Disgrafía y otros">F81.3 - Trastorno mixto del desarrollo escolar (disgrafía y otros)</option>
<option value="Autismo infantil">F84.0 - Autismo infantil</option>
<option value="Autismo atípico">F84.1 - Autismo atípico</option>
<option value="Síndrome de Rett">F84.2 - Síndrome de Rett</option>
<option value="Otro trastorno desintegrativo de la infancia">F84.3 - Otro trastorno desintegrativo de la infancia</option>
<option value="Síndrome de Asperger">F84.5 - Síndrome de Asperger</option>
<option value="Otros trastornos generalizados del desarrollo">F84.8 - Otros trastornos generalizados del desarrollo</option>
<option value="Trastorno específico del desarrollo de la motricidad">F82 - Trastorno específico del desarrollo de la motricidad</option>
<option value="Trastorno mixto del desarrollo psicológico">F83 - Trastorno mixto del desarrollo psicológico</option>
<option value="Otros trastornos del desarrollo psicológico">F88 - Otros trastornos del desarrollo psicológico</option>
<option value="Trastorno del desarrollo psicológico, sin especificación">F89 - Trastorno del desarrollo psicológico, sin especificación</option>
<option value="Neurofibromatosis, tipo 1 (enfermedad de von Recklinghausen)">Q85.0 - Neurofibromatosis, tipo 1 (enfermedad de von Recklinghausen)</option>
<option value="Malformaciones congénitas del cerebro no especificadas">Q04.9 - Malformaciones congénitas del cerebro no especificadas</option>
<option value="Trastorno cognitivo leve relacionado con daño cerebral o enfermedad orgánica">F06.7 - Trastorno cognitivo leve relacionado con daño cerebral o enfermedad orgánica</option>
<option value="Trisomía 21, no mosaico (Síndrome de Down)">Q90.0 - Trisomía 21, no mosaico (Síndrome de Down)</option>
<option value="Trisomía 21, mosaico">Q90.1 - Trisomía 21, mosaico</option>
<option value="Trisomía 21, por translocación">Q90.2 - Trisomía 21, por translocación</option>
<option value="Síndrome de Down, no especificado">Q90.9 - Síndrome de Down, no especificado</option>
<option value="Síndrome de Edwards (Trisomía 18)">Q91.0-Q91.9 - Síndrome de Edwards (Trisomía 18)</option>
<option value="desarrollo del lenguaje">F80 - Trastornos del Desarrollo del Lenguaje</option>
<option value="TEA">F84 - Trastornos del Espectro Autista (TEA)</option>
<option value="TDAH">F90 - Trastorno por Déficit de Atención e Hiperactividad (TDAH)</option>
<option value="dispraxia">F88 - Trastornos del Desarrollo de la Coordinación (Dispraxia)</option>
<option value="Trastorno de la conducta">F91 - Trastorno de la Conducta</option>
<option value="Trastorno de la conducta y déficit cognitivo">F92 - Trastorno de la Conducta con Déficit Cognitivo</option>
<option value="Trastorno de la emocional infancia">F93 - Trastorno Emocional en la Infancia</option>
<option value="Trastorno de la conducta relacional">F94 - Trastornos de la Conducta Relacional</option>
<option value="tics">F95 - Trastornos de los Tics</option>
<option value="Trastorno del sueño neurodesarrollo">F96 - Trastornos del Sueño Relacionados con el Neurodesarrollo</option>
<option value="epilepsia">G40 - Epilepsia</option>
<option value="trastornos cromosómicos">Q99 - Trastornos Cromosómicos No Especificados</option>
<option value="trastornos del aprendizaje">Trastornos del Aprendizaje (Dislexia, Discalculia, Disgrafía)</option>
<option value="trastornos de la comunicación">Trastornos de la Comunicación (Trastorno del Lenguaje Expresivo y Receptivo, Tartamudez, Trastorno de la Voz)</option>
<option value="trastornos del movimiento">Trastornos del Movimiento (Dispraxia, Trastorno de Tics, Trastorno de Movimientos Estereotipados)</option>
<option value="síndrome de X Frágil">Síndrome de X Frágil</option>
<option value="Trastorno de la integración sensorial">Trastorno de la Integración Sensorial</option>
<option value="síndrome de Williams">Síndrome de Williams</option>
<option value="síndrome de Prader-Willi">Síndrome de Prader-Willi</option>
<option value="síndrome de Angelman">Síndrome de Angelman</option>
<option value="síndrome de 22q11">Síndrome de Borrado 22q11</option>
            </select>
            <p>* Mantén presionada la tecla Ctrl (Windows) o Cmd (Mac) para seleccionar múltiples diagnósticos.</p><br><br>
        <label for="fotografia">Fotografía:<span class="error" style='color:red'>*</span></label>
        <input type="file" name="fotografia"required title="Debe volver a guardar la fotografia del Beneficiario" ><br><br>
        <img src="uploads/fotos/<?php echo htmlspecialchars($beneficiario['fotografia'], ENT_QUOTES, 'UTF-8'); ?>" alt="Fotografía Actual" style="max-width: 150px; height: auto;"><br><br>

        <button type="submit">Guardar Cambios</button>
    </form><br><br><br>
    <?php
// Actualizar la información del beneficiario si se envía el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Captura de datos del formulario
    $nombre_completo = $_POST['nombre_completo'];
    $documento_identidad = $_POST['documento_identidad'];
    $fecha_nacimiento = $_POST['fecha_nacimiento'];
    $correo_electronico = $_POST['correo_electronico'];
    $acudiente = $_POST['acudiente'];
    $institucion_patrocinadora = $_POST['institucion_patrocinadora'];
    $grupo = $_POST['grupo'];
    $programa = $_POST['programa'];
    $modalidad = $_POST['modalidad'];
    $antiguedad = $_POST['antiguedad'];
    $sede = $_POST['sede'];
    $areas = $_POST['areas'];
    $investigacion = $_POST['investigacion'];
    $profesionales = $_POST['profesionales'];
    $diagnosis = isset($_POST['diagnosis']) ? implode(", ", $_POST['diagnosis']) : ''; // Convierte el array en cadena

    // Manejo de la fotografía
    $fotografia = $_FILES['fotografia']['name'];
    if (!empty($fotografia)) {
        $target_dir = "uploads/fotos/";
        $target_file = $target_dir . basename($fotografia);

        // Validar tipo de archivo
        $file_type = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        $allowed_types = ['jpg', 'jpeg', 'png', 'gif'];
        if (in_array($file_type, $allowed_types)) {
            // Mover el archivo al directorio
            if (move_uploaded_file($_FILES['fotografia']['tmp_name'], $target_file)) {
                $fotografia = basename($fotografia); // Solo guarda el nombre del archivo
            } else {
                echo "Error al subir la fotografía.";
                exit;
            }
        } else {
            echo "Tipo de archivo no permitido. Solo se aceptan JPG, JPEG, PNG, y GIF.";
            exit;
        }
    } else {
        // Si no se subió una nueva foto, mantener la existente
        $fotografia = $beneficiario['fotografia'];
    }

    // Actualizar los datos en la base de datos
    $sql = "UPDATE beneficiarios 
            SET nombre_completo = ?, documento_identidad = ?, fecha_nacimiento = ?, 
                correo_electronico = ?, acudiente = ?, institucion_patrocinadora = ?, 
                grupo = ?, programa = ?, modalidad = ?, sede = ?, antiguedad = ?, areas = ?, 
                investigacion = ?, profesionales = ?, diagnosis = ?, fotografia = ? 
            WHERE id = ?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        echo "Error en la preparación de la consulta: " . $conn->error;
        exit;
    }

    $stmt->bind_param(
        "ssssssssssssssssi",
        $nombre_completo,
        $documento_identidad,
        $fecha_nacimiento,
        $correo_electronico,
        $acudiente,
        $institucion_patrocinadora,
        $grupo,
        $programa,
        $modalidad,
        $antiguedad,
        $sede,
        $areas,
        $investigacion,
        $profesionales,
        $diagnosis,
        $fotografia,
        $id
    );

    if ($stmt->execute()) {
        echo "Beneficiario actualizado correctamente.";
        header("Location: add_beneficiario2.php"); // Redirigir a la lista
        exit;
    } else {
        echo "Error al actualizar el beneficiario: " . $stmt->error;
        exit;
    }
}
ob_end_flush(); // Envía el contenido del buffer de salida
    ?>
</body>
</html>
