<?php
include 'db_config.php';
include 'index.php';
include "estilos.php";

// Crear conexión
$mysqli = new mysqli($host, $user, $pass, $db);

// Verificar conexión
if ($mysqli->connect_error) {
    die("Conexión fallida: " . $mysqli->connect_error);
}

// Comprobar si el formulario se envió
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $participant_name = $_POST['participant_name'];
    $modalidad_deporte = $_POST['modalidad_deporte'];
    $correct_classifications = intval($_POST['correct']); 

    // Preparar la consulta para insertar en la base de datos
    $sql = "INSERT INTO funciones_ejecutivas (participant_name, modalidad_deporte, clasificaciones_correctas) VALUES (?, ?, ?)";

    if ($stmt = $mysqli->prepare($sql)) {
        $stmt->bind_param("ssi", $participant_name, $modalidad_deporte, $correct_classifications);
        if ($stmt->execute()) {
            echo "Clasificaciones guardadas exitosamente.";
        } else {
            echo "Error al guardar clasificaciones: " . $stmt->error;
        }
        $stmt->close();
    } else {
        echo "Error en la preparación de la consulta: " . $mysqli->error;
    }
}
?>

<br><br>
<a href="resultados.php" style="font-size: 16px; text-decoration: none; color: blue;">Ver Resultados</a>
