<?php
// Página principal de la aplicación móvil
// archivo escritura3.php
include 'db_config.php';
include 'index3.php';

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante

// Lista de temas sencillos
$temas = [
    "Mi día favorito de la semana",
    "Un paseo al parque",
    "Mi animal favorito",
    "Mi comida favorita",
    "Un día en la playa",
    "Cómo me siento hoy",
    "Mi familia",
    "Mi juguete favorito",
    "Mi escuela y mis amigos",
    "Un día de lluvia"
];

// Función para elegir un tema aleatorio
$temaSeleccionado = $temas[array_rand($temas)];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluación Académica</title>
    <link rel="stylesheet" href="style.css">
    <style type="text/css">
    </style>
</head>
<body>
    <header class="main-header">
        <h1>Evaluación de Habilidades Académicas Básicas</h1>
    </header>
    <form action="save_result3.php" method="post">
        <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>

        <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" readonly>

        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <select id="modalidad_deporte" name="modalidad_deporte" required>
            <option value="ninguna">Ninguna</option>
            <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Resistencia moderada</option>
            <option value="aerobicos adaptados">Aeróbicos adaptados</option>
        </select>
        <main class="content">
            <!-- Módulo de Escritura -->
            <section class="module" id="writing-module">
                <h2>Prueba de Escritura</h2>
                <p>Escribe una historia breve sobre el siguiente tema:</p>
                <div id="writing-prompt">
                    <strong>Tema:</strong> <?= $temaSeleccionado ?>
                </div>
                <textarea name="writing_input" id="writing-input" placeholder="Escribe aquí..." rows="6"></textarea>
                <button type="submit" id="submit" class="btn">Enviar Respuesta</button>
            </section>
    </form>
    <br><br>
    <?php include 'footer.php'; ?>

    <script src="script3.js"></script>
</body>
</html>
