<?php
// archivo escultura_modelado3.php
include 'db_config.php';
include 'index3.php'; 

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Evaluación en Artes Visuales</title>
</head>
<body>
    <h1>Evaluación en Artes Visuales: Escultura y Modelado</h1>
    <form action="save_result_escultura_modelado3.php" method="POST" enctype="multipart/form-data">
       <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>
        <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" required>

        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <select id="modalidad_deporte" name="modalidad_deporte" required>
            <option value="ninguna">Ninguna</option>
            <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Resistencia moderada</option>
            <option value="aerobicos adaptados">Aeróbicos adaptados</option>
        </select>
<br> <br>

        <h2>Utilizando plastilina, arcilla, madera o cualquier material de tu preferencia, realiza el modelado de una escultura.</h2>
        <label for="puntaje_destreza">Destreza Manual (1-10):</label>
        <input type="number" id="puntaje_destreza" name="puntaje_destreza" min="1" max="10" required>

        <label for="puntaje_fuerza">Fuerza (1-10):</label>
        <input type="number" id="puntaje_fuerza" name="puntaje_fuerza" min="1" max="10" required>

        <label for="puntaje_coordinacion">Coordinación en las manos (1-10):</label>
        <input type="number" id="puntaje_coordinacion" name="puntaje_coordinacion" min="1" max="10" required><br>

        <button type="submit">Enviar Evaluación</button>
    </form>
</body>
</html>
