    <?php
// archivo funciones3.php
// Función para contar las respuestas correctas
include 'db_config.php';
//include 'index.php';

// Función para obtener preguntas desde la base de datos
function obtenerPreguntas($categoria, $dificultad) {
    $pdo = conectarBaseDatos();

    $query = "SELECT id, texto_pregunta, opciones, respuesta_correcta 
              FROM preguntas 
              WHERE categoria = :categoria AND dificultad = :dificultad";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':categoria', $categoria);
    $stmt->bindParam(':dificultad', $dificultad);
    $stmt->execute();

    $preguntas = [];
    while ($fila = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $preguntas[] = [
            'id' => $fila['id'],
            'text' => $fila['texto_pregunta'],
            'options' => json_decode($fila['opciones']), // Decodificar JSON almacenado
            'answer' => $fila['respuesta_correcta']
        ];
    }
    return $preguntas;
}

// Función para guardar respuestas del usuario en la base de datos
function guardarRespuestas($nombre, $categoria, $respuestas) {
    $pdo = conectarBaseDatos();

    foreach ($respuestas as $idPregunta => $respuestaUsuario) {
        // Guardar datos en la base de datos
    $sq = "INSERT INTO resolucion_problemas 
              (participant_name, modalidad_deporte, categoria, dificultad, aciertos, preguntasSeleccionadas, recomendaciones) 
              VALUES (?, ?, ?, ?, ?, ?, ?)";

    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param(
            "ssssiss",
            $nombre,
            $modalidad_deporte,
            $categoria,
            $dificultad,
            $aciertos,
            $preguntasSeleccionadasJSON,
            $recomendaciones
        );

        if ($stmt->execute()) {
            echo "¡Datos guardados correctamente!";
        } else {
            echo "Error al guardar los datos: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo "Error en la consulta SQL: " . $conn->error;
    }

// Función para contar respuestas correctas
function contarRespuestasCorrectas($respuestasUsuario, $categoria, $dificultad) {
    $preguntas = obtenerPreguntas($categoria, $dificultad);

    $correctas = 0;
    foreach ($preguntas as $pregunta) {
        $idPregunta = $pregunta['id'];
        if (isset($respuestasUsuario[$idPregunta]) && $respuestasUsuario[$idPregunta] == $pregunta['answer']) {
            $correctas++;
        }
    }

    return $correctas;
}
}
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generar Cuestionario</title>
</head>
<body>
    <h1>Generar Cuestionario</h1>
    <form method="POST" action="generar_preguntas3.php" id="formCuestionario">

        <!--label for="participant_name">Nombre del Participante:</label-->
        <input type="hidden" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante ?? '', ENT_QUOTES, 'UTF-8'); ?>" readonly>

        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
            <select id="modalidad_deporte" name="modalidad_deporte" required>
                <option value="ninguna">Ninguna</option>
                <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
                <option value="resistencia moderada">Resistencia moderada</option>
                <option value="aerobicos adaptados">Aeróbicos adaptados</option>
            </select>
        
        <label for="categoria">Selecciona la categoría:</label>
        <select name="categoria" id="categoria">
            <option value="matematicas">Matemáticas</option>
            <option value="logica">Lógica</option>
            <option value="ciencias">Ciencia</option>
        </select><br><br>
        
        <label for="dificultad">Selecciona la dificultad:</label>
        <select name="dificultad" id="dificultad">
            <option value="facil">Fácil</option>
            <option value="medio">Medio</option>
            <option value="dificil">Difícil</option>
        </select><br><br>
       <!-- Campo oculto para enviar las preguntas seleccionadas --> 
      <input type="hidden" name="preguntasSeleccionadas" id="preguntasSeleccionadas">  

        <!-- Botón para enviar el formulario -->
        <button type="submit">Generar Cuestionario</button>
    </form>
</body>
</html>