// Archivo: funciones_ejecutivas.js

function shuffleArray(array) {
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]];
    }
    return array;
}

function drop(event) {
    event.preventDefault();
    const data = event.dataTransfer.getData('text');
    const carta = document.getElementById(data);
    const categoria = event.target.closest('.categoria');

    if (categoria && carta.dataset.type === categoria.dataset.type) {
        categoria.appendChild(carta);
        carta.setAttribute('draggable', 'false');
        actualizarConteoCorrecto();
    }
}

function actualizarConteoCorrecto() {
    const cartas = document.querySelectorAll('.carta');
    let conteoCorrecto = 0;

    cartas.forEach(carta => {
        const categoriaPadre = carta.closest('.categoria');
        if (categoriaPadre && carta.dataset.type === categoriaPadre.dataset.type) {
            conteoCorrecto++;
        }
    });

    document.getElementById('correctCount').value = conteoCorrecto;
}

function prepareSubmission() {
    actualizarConteoCorrecto();
}

function iniciarPrueba() {
    const categorias = Array.from(document.querySelectorAll('.categoria'));
    const shuffledCategorias = shuffleArray(categorias);
    const container = document.getElementById('categoriasContainer');
    container.innerHTML = '';

    shuffledCategorias.forEach(categoria => {
        container.appendChild(categoria);
    });
}

document.addEventListener('DOMContentLoaded', () => {
    iniciarPrueba();
});
