<?php
// archivo funciones_ejecutivas3.php
include 'db_config.php';
include 'index3.php';

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante

// Declaración de tarjetas
$cards = [
    ['imagen' => 'rojo_circulo.png', 'color' => 'rojo', 'forma' => 'circulo', 'tipo' => 'figura'],
    ['imagen' => 'rojo_cuadrado.png', 'color' => 'rojo', 'forma' => 'cuadrado', 'tipo' => 'figura'],
    ['imagen' => 'verde_circulo.png', 'color' => 'verde', 'forma' => 'circulo', 'tipo' => 'figura'],
    ['imagen' => 'fruta_uva.png', 'color' => 'morado', 'forma' => 'redonda', 'tipo' => 'fruta'],
    ['imagen' => 'fruta_banana.png', 'color' => 'amarillo', 'forma' => 'alargada', 'tipo' => 'fruta'],
    ['imagen' => 'amarillo_cuadrado.png', 'color' => 'amarillo', 'forma' => 'cuadrado', 'tipo' => 'figura'],
    ['imagen' => 'azul_circulo.png', 'color' => 'azul', 'forma' => 'circulo', 'tipo' => 'figura'],
    ['imagen' => 'fruta_manzana.png', 'color' => 'rojo', 'forma' => 'redonda', 'tipo' => 'fruta'],
    ['imagen' => 'animal_gato.png', 'color' => 'gris', 'forma' => 'animal', 'tipo' => 'animal'],
    ['imagen' => 'animal_perro.png', 'color' => 'marron', 'forma' => 'animal', 'tipo' => 'animal']
];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Test de Clasificación de Tarjetas (WCST)</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .card-item {
            display: inline-block;
            margin: 10px;
            text-align: center;
            cursor: move;
        }
        .card-item img {
            width: 100px;
            height: 100px;
        }
        .dropzone {
            width: 120px;
            height: 120px;
            border: 2px dashed #aaa;
            display: inline-block;
            margin: 10px;
            padding: 10px;
            text-align: center;
            background-color: #f9f9f9;
        }
        #dropzones-container {
            display: flex;
            justify-content: space-around;
            margin-top: 20px;
        }
        .dropzone h4 {
            font-size: 14px;
            color: #555;
        }
        input[type="submit"] {
            margin-top: 20px;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
        }
        #scoreDisplay {
            margin-top: 10px;
            font-size: 18px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>Test de Test de Funciones Ejecutivas. Clasificación de Tarjetas (WCST)</h1>
    <!--h1>Bienvenido al </h1-->
    
    <label for="criterio_clasificacion">Criterio de Clasificación:</label><br>
    <select id="criterio_clasificacion" name="criterio_clasificacion" onchange="updateCriterio()">
        <option value="color">Color</option>
        <option value="forma">Forma</option>
        <option value="tipo">Tipo (figuras, frutas, animales)</option>
    </select><br><br>

    <!-- Contenedor de tarjetas -->
    <div id="cards-container">
        <?php foreach ($cards as $index => $card): ?>
            <div class="card-item" draggable="true" ondragstart="drag(event)" 
                data-color="<?= $card['color'] ?>" data-forma="<?= $card['forma'] ?>" data-tipo="<?= $card['tipo'] ?>" 
                id="card<?= $index ?>">
                <img src="uploads/fotos/<?= $card['imagen'] ?>" alt="<?= $card['tipo'] ?>">
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Contenedor dinámico de dropzones -->
    <div id="dropzones-container"></div>

    <p id="evaluation-result"></p>

    <!-- Formulario para enviar resultados -->
    <form action="guardar_resultados3.php" method="post" onsubmit="prepareSubmission()">
        <input type="hidden" name="correct" id="correctCount" value="0">
        <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" >

        <label for="documento_identidad">Número de Documento de Identidad:</label>
        <input type="text" id="documento_identidad" name="documento_identidad" value="<?= htmlspecialchars($documentoIdentidad) ?>" readonly>
        
        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <select id="modalidad_deporte" name="modalidad_deporte">
            <option value="ninguna">Ninguna modalidad</option>
            <option value="baja intensidad y equilibrio">Ejercicios de baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Ejercicios de resistencia moderada</option>
            <option value="aerobicos adaptados">Ejercicios aeróbicos adaptados</option>
        </select><br><br>
        <input type="submit" value="Enviar Respuestas">
    </form><br><br>

    <script>
        let correctClassifications = 0;

        function allowDrop(event) {
            event.preventDefault();
        }

        // Función drag que obtiene el elemento correcto (card-item) subiendo en el DOM si es necesario
        function drag(event) {
            let element = event.target;
            // Si se hizo clic en un hijo (por ejemplo, la imagen), sube hasta encontrar la tarjeta
            while (element && !element.classList.contains("card-item")) {
                element = element.parentNode;
            }
            if (element && element.id) {
                event.dataTransfer.setData("text", element.id);
            }
        }

        function drop(event, expectedValue, criteria) {
            event.preventDefault();
            const cardId = event.dataTransfer.getData("text");
            const cardElement = document.getElementById(cardId);
            if (!cardElement) return; // Si no se encuentra el elemento, salir.
            const cardValue = cardElement.getAttribute(`data-${criteria}`);
            if (cardValue === expectedValue) {
                const dropzone = event.currentTarget;
                // Evitar contar duplicados: si la dropzone ya contiene el elemento, no se suma.
                if (!dropzone.contains(cardElement)) {
                    dropzone.appendChild(cardElement);
                    correctClassifications++;
                    updateScoreDisplay();
                }
            }
        }

        function updateScoreDisplay() {
            const scoreDisplay = document.getElementById("scoreDisplay");
            if (scoreDisplay) {
                scoreDisplay.innerText = `Aciertos: ${correctClassifications}`;
            }
        }

        function prepareSubmission() {
            document.getElementById("correctCount").value = correctClassifications;
        }

        function updateCriterio() {
            const criterio = document.getElementById("criterio_clasificacion").value;
            const container = document.getElementById("dropzones-container");
            container.innerHTML = ''; // vaciar container

            let cestas = [];

            if (criterio === 'color') {
                cestas = ['rojo', 'marron', 'azul', 'amarillo', 'verde', 'morado', 'gris'];
            } else if (criterio === 'forma') {
                cestas = ['circulo', 'cuadrado', 'redonda', 'animal', 'alargada'];
            } else if (criterio === 'tipo') {
                cestas = ['fruta', 'figura', 'animal'];
            }

            cestas.forEach(cesta => { 
                let dropzone = document.createElement("div");
                dropzone.className = "dropzone";
                dropzone.ondrop = (event) => drop(event, cesta, criterio);
                dropzone.ondragover = allowDrop;
                let label = document.createElement("h4");
                label.textContent = cesta;
                dropzone.appendChild(label);
                container.appendChild(dropzone);
            });

            // Crear o actualizar el display del puntaje
            let scoreDisplay = document.getElementById("scoreDisplay");
            if (!scoreDisplay) {
                scoreDisplay = document.createElement("p");
                scoreDisplay.id = "scoreDisplay";
                scoreDisplay.innerText = "Aciertos: 0";
                container.parentNode.insertBefore(scoreDisplay, container.nextSibling);
            } else {
                scoreDisplay.innerText = "Aciertos: 0";
            }
            // Reiniciamos el contador
            correctClassifications = 0;
        }

        window.onload = function() {
            openTab('info');
            updateCriterio();
        }
    </script>
</body>
</html>
