<?php
// archivo generar_preguntas.php
// Conexión a la base de datos
include 'db_config.php';
include "encabezado.php";
//var_dump($_POST); // este codigo muestra cuales parametros se estan pasndo en el formulario en el metodo POST

// Verificar si la sesión está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verificamos si el método de la solicitud es POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
$categoria = $_POST['categoria'];  // 'matematicas', 'logica', etc.
$dificultad = $_POST['dificultad'];  // 'facil', 'medio', 'dificil'
$participant_name = isset($_POST['participant_name']) ? $_POST['participant_name'] : '';
$modalidad_deporte = isset($_POST['modalidad_deporte']) ? $_POST['modalidad_deporte'] : '';
}
?>
<form action="procesar_respuestas.php" method="POST">
    <h2>Resolución de Problemas, Matemáticas, Lógica y Ciencias</h2>
    <!--p>Nombre: <input type="text" name="nombre" value="<?= $nombre ?>" required /></p-->
            <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($participant_name) ?>" readonly>
        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <input type="text" id="modalidad_deporte" name="modalidad_deporte" value="<?= htmlspecialchars($modalidad_deporte) ?>" readonly>
<?php
// Consultamos 5 preguntas aleatorias de la base de datos según la categoría y dificultad seleccionadas
$sql = "SELECT * FROM preguntas WHERE categoria = ? AND dificultad = ? ORDER BY RAND() LIMIT 5";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $categoria, $dificultad);
$stmt->execute();
$result = $stmt->get_result();

// Verificamos si hay resultados
if ($result->num_rows > 0) {
    echo "<h2>Preguntas de $categoria - Dificultad: $dificultad</h2>";

    // Pasamos los datos iniciales al siguiente formulario
    echo "<input type='hidden' name='participant_name' value='$participant_name'>";
    echo "<input type='hidden' name='modalidad_deporte' value='$modalidad_deporte'>";
    echo "<input type='hidden' name='categoria' value='$categoria'>";
    echo "<input type='hidden' name='dificultad' value='$dificultad'>";

    // Generamos las preguntas
$i = 1;
while ($row = $result->fetch_assoc()) {
    $pregunta = $row['pregunta'];
    $opciones = json_decode($row['opciones']);  // Decodificamos el JSON para las opciones
    $respuesta_correcta = $row['respuesta_correcta'];

    echo "<div style='margin-bottom: 20px;'>";
    echo "<h4>$i. $pregunta</h4>";

    // Mezclamos las opciones de manera aleatoria antes de mostrarlas
    shuffle($opciones);

    // Generamos las opciones (radio buttons) con el orden aleatorio
    foreach ($opciones as $opcion) {
        echo "<label><input type='radio' name='respuesta_$i' value='" . htmlspecialchars($opcion) . "' required> " . htmlspecialchars($opcion) . "</label><br>";
    }

    // Guardamos la respuesta correcta en un input hidden para poder validarla después
    echo "<input type='hidden' name='respuesta_correcta_$i' value='" . htmlspecialchars($respuesta_correcta) . "'>";
    echo "</div>";

    $i++; 
}


    // Botón de envío
    echo "<input type='submit' value='Enviar Respuestas'>";
    echo "</form>";
} else {
    echo "<p>No se encontraron preguntas para esta categoría y dificultad.</p>";
}
?>
</form><br><br><br>