<?php
// archivo generar_reporte_comfenalco.php
include 'encabezado2.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generar Informe Beneficiarios Comfenalco</title>
    <style>
        .seguimiento-menu {
            margin-top: 20px;
        }
        button {
            padding: 10px 20px;
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }

        /* Estilos para el menú */
        ul {
            list-style-type: none;
            padding: 0;
            overflow: hidden;
            background-color: #333;
        }

        li {
            float: left;
        }

        li a, .dropbtn {
            display: inline-block;
            color: white;
            text-align: center;
            padding: 14px 16px;
            text-decoration: none;
        }

        li a:hover, .dropdown:hover .dropbtn {
            background-color: #111;
        }

        .dropdown {
            display: inline-block;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            background-color: #f9f9f9;
            min-width: 200px;
            box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
            z-index: 1;
        }

        .dropdown-content a {
            color: black;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
            text-align: left;
        }

        .dropdown-content a:hover {
            background-color: #f1f1f1;
        }

        .dropdown:hover .dropdown-content {
            display: block;
        }
    </style>

</head>
<body>
    <h1>Generar Informe de Beneficiarios - Comfenalco</h1>
    <p>Seleccione el trimestre para generar el informe en Excel de todos los beneficiarios cuya institución patrocinadora sea Comfenalco.</p>

    <!-- Selección de periodicidad -->
    <div class="seguimiento-menu">
        <label for="periodo">Seleccione el trimestre:</label>
        <form id="reporteForm">
            <select id="periodo" name="periodo">
                <option value="">--Seleccione una evaluación--</option>
                <option value="primer_trimestre">Primer Trimestre</option>
                <option value="segundo_trimestre">Segundo Trimestre</option>
                <option value="tercer_trimestre">Tercer Trimestre</option>
                <option value="cuarto_trimestre">Cuarto Trimestre</option>
            </select>
        </form>
        <br><br>
        <button onclick="generateExcelReport()">Generar Informe en Excel</button>
    </div>

    <script>
        function generateExcelReport() {
            const period = document.getElementById('periodo').value;
            if (period !== "") {
                // Abrir la generación del Excel en una nueva pestaña
                window.open('generate_excel_comfenalco.php?period=' + period, '_blank');
            } else {
                alert("Por favor, seleccione un período.");
            }
        }
    </script>
</body>
</html>
