<?php
// Incluir las bibliotecas FPDF y FPDI
require('fpdf/fpdf.php');
require('vendor/autoload.php');  // Usar Composer para FPDI si lo necesitas

// Iniciar el almacenamiento en búfer de salida para evitar salidas previas
ob_start();

include 'db_config.php';  // Archivo de conexión a la base de datos

$conn = new mysqli($host, $user, $pass, $db);

// Verificar la conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtener los datos enviados por el formulario
$beneficiario_id = isset($_POST['beneficiario_id']) ? intval($_POST['beneficiario_id']) : 0;
$tarifa_mensual = isset($_POST['tarifa_mensual']) ? floatval($_POST['tarifa_mensual']) : 0.00;
$institucion_patrocinadora = isset($_POST['institucion_patrocinadora']) ? $_POST['institucion_patrocinadora'] : '';

// Consultar los datos del beneficiario desde la base de datos
$sql = "SELECT nombre_completo, documento_identidad, fotografia, institucion_patrocinadora FROM beneficiarios WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $beneficiario_id);
$stmt->execute();
$stmt->bind_result($nombre_completo, $documento_identidad, $fotografia, $institucion_patrocinadora);
$stmt->fetch();
$stmt->close();

// Crear el certificado en formato PDF
$pdf = new FPDF();
$pdf->AddPage();

// Insertar el logo (escudo) en la esquina superior izquierda
if (file_exists('uploads/fotos/escudo.JPG')) {
    $pdf->Image('uploads/fotos/escudo.JPG', 20, 20, 30, 30);  // Coordenadas: x=20, y=20, tamaño=30x30
}
if (file_exists('uploads/fotos/logo.png')) {
    $pdf->Image('uploads/fotos/logo.png', 85, 230, 30, 30);  // Coordenadas: x=80, y=250, tamaño=30x30
}

// Insertar el encabezado
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 7, mb_convert_encoding('FUNDACIÓN PROYECTO 21', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 7, mb_convert_encoding('CENTRO ESPECIALIZADO', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->Cell(0, 7, mb_convert_encoding('ANDRÉS FELIPE MELÉNDEZ FORERO', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->Cell(0, 7, mb_convert_encoding('NIT 901313808-6', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

// Espaciado antes del contenido principal
$pdf->Ln(20);

// Insertar la fecha actual
$fecha_actual = date('F j, Y');  // Formato de fecha: mes en letras, día y año
$pdf->SetFont('Arial', '', 12);
$pdf->SetXY(25, 70);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("Medellín, $fecha_actual\nSeñores:\n$institucion_patrocinadora:\nAsunto: certificación.", 'ISO-8859-1', 'UTF-8'));

// Insertar el contenido del certificado
$pdf->SetFont('Arial', '', 12);
$pdf->SetXY(25, 115);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("La Fundación Proyecto 21 Centro Especializado Andrés Felipe Meléndez Forero certifica que el/la joven $nombre_completo, con documento de identidad # $documento_identidad, para la fecha $fecha_actual, se encuentra matriculado(a) en nuestra institución en los programas de atención educativa, ajustes razonables e inclusión educativa y social.", 'ISO-8859-1', 'UTF-8'));

// Insertar la tarifa mensual en el certificado
$pdf->SetXY(25, 150);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("Tarifa mensual para este año es de $" . number_format($tarifa_mensual, 2, ',', '.') . " COP.", 'ISO-8859-1', 'UTF-8'));

// Continuar con el contenido del certificado
$pdf->SetXY(25, 163);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("La fundación Proyecto 21, tiene cuenta de ahorros Bancolombia # 097-026559-59", 'ISO-8859-1', 'UTF-8'));

$pdf->SetXY(25, 175);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("Representante legal: María Eugenia Forero Sánchez, con c.c # 60325337", 'ISO-8859-1', 'UTF-8'));

$pdf->SetXY(25, 190);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("Agradecemos de antemano su atención. Cualquier información adicional, la suministramos en los teléfonos:

+57 3163421176
+57 3008894834
6045080887", 'ISO-8859-1', 'UTF-8'));

// Pie de página con los datos de contacto
$pdf->SetY(-35);  // Coloca el pie de página a 35 puntos desde el final de la página
$pdf->SetFont('Arial', '', 10);
$pdf->MultiCell(0, 7, mb_convert_encoding("Carrera 48 Ecuador Nº 59-28 Medellín. Correo: ceciproyecto21@hotmail.com. Tel: +57 3007253300", 'ISO-8859-1', 'UTF-8'));

// Mostrar o descargar el PDF
$pdf->Output('I', 'Certificado_' . $nombre_completo . '.pdf');

// Cerrar la conexión a la base de datos
$conn->close();

// Limpiar el búfer de salida
ob_end_flush();
