<?php
// generate_excel_comfenalco.php

require 'vendor/autoload.php';  // Asegúrate de tener PhpSpreadsheet instalado
include 'db_config.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Limpiar el buffer de salida para evitar errores
if (ob_get_length()) {
    ob_end_clean();
}

// Obtener el parámetro de periodicidad de la URL
$period = isset($_GET['period']) ? $_GET['period'] : '';

// Verificar que se haya seleccionado un período válido
if (empty($period)) {
    die("Período inválido.");
}

// Consultar todos los beneficiarios cuya institución patrocinadora es Comfenalco
$sql_beneficiarios = "SELECT * FROM beneficiarios WHERE institucion_patrocinadora = 'Comfenalco'";
$result_beneficiarios = $conn->query($sql_beneficiarios);

if ($result_beneficiarios->num_rows == 0) {
    die("No se encontraron beneficiarios de Comfenalco.");
}

// Crear el archivo Excel
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Encabezados adicionales en letras grandes
$sheet->setCellValue('A1', mb_convert_encoding('SEGUIMIENTO ATENCIÓN A USUARIOS BENEFICIARIOS DEL SUBSIDIO EDUCATIVO DE COMFENALCO', 'ISO-8859-1', 'UTF-8'));
$sheet->mergeCells('A1:K1');
$sheet->getStyle('A1')->getFont()->setBold(true)->setSize(16);

$reportTitle = '';
$current_year = date('Y');  // Año actual
switch ($period) {
    case 'primer_trimestre':
        $reportTitle = 'PRIMER TRIMESTRE DEL AÑO ' . $current_year;
        break;
    case 'segundo_trimestre':
        $reportTitle = 'SEGUNDO TRIMESTRE DEL AÑO ' . $current_year;
        break;
    case 'tercer_trimestre':
        $reportTitle = 'TERCER TRIMESTRE DEL AÑO ' . $current_year;
        break;
    case 'cuarto_trimestre':
        $reportTitle = 'CUARTO TRIMESTRE DEL AÑO ' . $current_year;
        break;
    default:
        die("Período no válido.");
}
$sheet->setCellValue('A2', mb_convert_encoding($reportTitle, 'ISO-8859-1', 'UTF-8'));
$sheet->mergeCells('A2:K2');
$sheet->getStyle('A2')->getFont()->setBold(true)->setSize(14);

$sheet->setCellValue('A3', mb_convert_encoding('INSTITUCIÓN: FUNDACIÓN PROYECTO 21', 'ISO-8859-1', 'UTF-8'));
$sheet->mergeCells('A3:K3');
$sheet->getStyle('A3')->getFont()->setBold(true)->setSize(14);

// Encabezados de las columnas
$sheet->setCellValue('A6', 'NOMBRE DEL USUARIO');
$sheet->setCellValue('B6', 'EDAD');
$sheet->setCellValue('C6', 'PROGRAMA');
$sheet->setCellValue('D6', 'MODALIDAD');
$sheet->setCellValue('E6', 'OBJETIVOS DEFINIDOS');
$sheet->setCellValue('F6', 'PLAN DE INTERVENCIÓN');
$sheet->setCellValue('G6', 'LOGROS');
$sheet->setCellValue('H6', 'TIPO DE USUARIO');
$sheet->setCellValue('I6', 'DISCIPLINAS Y ÁREAS DE ATENCIÓN');
$sheet->setCellValue('J6', 'NOMBRE DE LOS PROFESIONALES');
$sheet->setCellValue('K6', 'OBSERVACIONES');

// Fila inicial para los datos
$row = 7;

// Recorrer cada beneficiario y obtener sus seguimientos según la periodicidad seleccionada
while ($beneficiario = $result_beneficiarios->fetch_assoc()) {
    // Calcular la edad del beneficiario a partir de la fecha de nacimiento
    $fecha_nacimiento = new DateTime($beneficiario['fecha_nacimiento']);
    $hoy = new DateTime();
    $edad = $hoy->diff($fecha_nacimiento)->y;

    // Consultar los seguimientos del beneficiario según la periodicidad seleccionada, y solo del año actual
    switch ($period) {
        case 'primer_trimestre':
            $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND YEAR(fecha_evaluacion) = ? AND (MONTH(fecha_evaluacion) BETWEEN 1 AND 3)";
            break;
        case 'segundo_trimestre':
            $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND YEAR(fecha_evaluacion) = ? AND (MONTH(fecha_evaluacion) BETWEEN 4 AND 6)";
            break;
        case 'tercer_trimestre':
            $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND YEAR(fecha_evaluacion) = ? AND (MONTH(fecha_evaluacion) BETWEEN 7 AND 9)";
            break;
        case 'cuarto_trimestre':
            $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND YEAR(fecha_evaluacion) = ? AND (MONTH(fecha_evaluacion) BETWEEN 10 AND 12)";
            break;
        default:
            die("Período no válido.");
    }

    // Preparar la consulta de seguimientos
    $stmt_seguimientos = $conn->prepare($sql_seguimientos);
    $stmt_seguimientos->bind_param("ii", $beneficiario['id'], $current_year);  // Asegurar el filtrado por año
    $stmt_seguimientos->execute();
    $result_seguimientos = $stmt_seguimientos->get_result();

    // Rellenar el archivo Excel con los datos del beneficiario y sus seguimientos
    while ($seguimiento = $result_seguimientos->fetch_assoc()) {
        $sheet->setCellValue('A' . $row, $beneficiario['nombre_completo']);
        $sheet->setCellValue('B' . $row, $edad);
        $sheet->setCellValue('C' . $row, $beneficiario['programa']);
        $sheet->setCellValue('D' . $row, $beneficiario['modalidad']);
        $sheet->setCellValue('E' . $row, $seguimiento['objetivos']);
        $sheet->setCellValue('F' . $row, $seguimiento['plan_accion']);
        $sheet->setCellValue('G' . $row, $seguimiento['desarrollo_cognitivo']);
        $sheet->setCellValue('G' . $row, $seguimiento['habilidades_sociales']);
        $sheet->setCellValue('G' . $row, $seguimiento['autonomia']);
        $sheet->setCellValue('G' . $row, $seguimiento['desempeño_academico']);
        $sheet->setCellValue('G' . $row, $seguimiento['competencia_lectoescritura']);
        $sheet->setCellValue('G' . $row, $seguimiento['matematica_basica']);
        $sheet->setCellValue('G' . $row, $seguimiento['habilidades_organizacionales']);
        $sheet->setCellValue('G' . $row, $seguimiento['desarrollo_cognitivo']);
        $sheet->setCellValue('H' . $row, $beneficiario['antiguedad']);
        $sheet->setCellValue('I' . $row, $beneficiario['areas']);
        $sheet->setCellValue('J' . $row, $beneficiario['profesionales']);
        $sheet->setCellValue('K' . $row, $seguimiento['observaciones']);
        $row++;
    }

    $stmt_seguimientos->close();
}

// Guardar el archivo Excel y ofrecerlo para descarga
$filename = "reporte_beneficiarios_comfenalco_" . $period . ".xlsx";

// Limpiar el buffer de salida para evitar errores
if (ob_get_length()) {
    ob_end_clean();
}

// Establecer los encabezados adecuados para la descarga del archivo
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Cache-Control: max-age=0');

// Guardar y enviar el archivo Excel
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');

$conn->close();
?>
