<?php
// Incluir las bibliotecas FPDF
require('fpdf/fpdf.php');
require('vendor/autoload.php');  // Usar Composer si es necesario

class PDF extends FPDF {
    // Sobrescribir la función Footer para añadir el logo al final de cada página
    function Footer() {
        // Mover la posición a 30 puntos desde el final de la página
        $this->SetY(-30);

        // Insertar el logo si existe
        if (file_exists('uploads/fotos/logo.png')) {
            $this->Image('uploads/fotos/logo.png', 85, null, 30, 30); // Coordenadas ajustables
        }

        // Añadir el pie de página
        $this->SetFont('Arial', '', 10);
        $this->MultiCell(0, -5, mb_convert_encoding("Carrera 48 Ecuador Nº 59-28 Medellín. Correo: ceciproyecto21@hotmail.com. Tel: +57 3007253300", 'ISO-8859-1', 'UTF-8'));
    }
}

// Iniciar el almacenamiento en búfer de salida para evitar salidas previas
ob_start();

include 'db_config.php';  // Archivo de conexión a la base de datos

$conn = new mysqli($host, $user, $pass, $db);

// Verificar la conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtener los datos enviados por el formulario
$beneficiario_id = isset($_POST['beneficiario_id']) ? intval($_POST['beneficiario_id']) : 0;
$institucion_destino = isset($_POST['institucion_destino']) ? $_POST['institucion_destino'] : '';

// Consultar los datos del beneficiario desde la base de datos
$sql = "SELECT nombre_completo, fecha_nacimiento, documento_identidad, diagnosis FROM beneficiarios WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $beneficiario_id);
$stmt->execute();
$stmt->bind_result($nombre_completo, $fecha_nacimiento, $documento_identidad, $diagnosis);
$stmt->fetch();
$stmt->close();

// Calcular la edad del beneficiario
$fecha_nacimiento_dt = new DateTime($fecha_nacimiento);
$hoy = new DateTime();
$edad = $hoy->diff($fecha_nacimiento_dt)->y;

// Obtener los datos del seguimiento desde la tabla "seguimientos"
$sql_seguimiento = "SELECT desarrollo_cognitivo, habilidades_sociales, autonomia, desempeño_academico, competencia_lectoescritura, matematica_basica, habilidades_organizacionales, recomendaciones, observaciones 
                    FROM seguimientos WHERE beneficiario_id = ? ORDER BY fecha_evaluacion DESC LIMIT 1";  
$stmt_seguimiento = $conn->prepare($sql_seguimiento);
$stmt_seguimiento->bind_param("i", $beneficiario_id);
$stmt_seguimiento->execute();
$stmt_seguimiento->bind_result($desarrollo_cognitivo, $habilidades_sociales, $autonomia, $desempeño_academico, $competencia_lectoescritura, $matematica_basica, $habilidades_organizacionales, $recomendaciones, $observaciones);
$stmt_seguimiento->fetch();
$stmt_seguimiento->close();

// Crear el informe en formato PDF
$pdf = new PDF();
$pdf->AddPage();

// Insertar el logo (escudo) en la esquina superior izquierda
if (file_exists('uploads/fotos/escudo.jpg')) {
    $pdf->Image('uploads/fotos/escudo.jpg', 20, 20, 30, 30);  // Coordenadas: x=20, y=20, tamaño=30x30
}

// Insertar el encabezado
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 7, mb_convert_encoding('FUNDACIÓN PROYECTO 21', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 7, mb_convert_encoding('CENTRO ESPECIALIZADO', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->Cell(0, 7, mb_convert_encoding('ANDRÉS FELIPE MELÉNDEZ FORERO', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->Cell(0, 7, mb_convert_encoding('NIT 901313808-6', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

// Espaciado antes del contenido principal
$pdf->Ln(20);

// Insertar la fecha actual
$fecha_actual = date('F j, Y');  // Formato de fecha: mes en letras, día y año
$pdf->SetFont('Arial', '', 12);
$pdf->SetXY(25, 70);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("Medellín, $fecha_actual\nPara: $institucion_destino\nAsunto: Informe de Desempeño de $nombre_completo", 'ISO-8859-1', 'UTF-8'));

// Insertar el contenido del informe
$pdf->SetFont('Arial', '', 12);
$pdf->SetXY(25, 115);  // Ajustar coordenadas para el texto principal
$pdf->MultiCell(0, 7, mb_convert_encoding("Respetado(a) Sr(a).\n\nMe complace presentar el informe de desempeño de $nombre_completo, quien ha demostrado logros significativos en su trayectoria educativa. A continuación, se detallan los aspectos relevantes de su desempeño y desarrollo.", 'ISO-8859-1', 'UTF-8'));

// Información General
$pdf->Ln(10);
$pdf->MultiCell(0, 7, mb_convert_encoding("1. Información General:\n\n- Nombre del Estudiante: $nombre_completo\n- Edad: $edad\n- Grado Actual: Atención educativa en Centro especializado.\n- Tipo de Discapacidad: $diagnosis", 'ISO-8859-1', 'UTF-8'));

// Logros y Desempeño
$pdf->Ln(10);
$pdf->MultiCell(0, 7, mb_convert_encoding("2. Logros y Desempeño:\n\n", 'ISO-8859-1', 'UTF-8'));
$pdf->MultiCell(0, 7, mb_convert_encoding("- Desarrollo Cognitivo: $desarrollo_cognitivo\n- Habilidades Sociales: $habilidades_sociales\n- Autonomía: $autonomia\n- Desempeño Académico: $desempeño_academico", 'ISO-8859-1', 'UTF-8'));

// Competencias y Habilidades
$pdf->Ln(10);
$pdf->MultiCell(0, 7, mb_convert_encoding("3. Competencias y Desarrollo de Habilidades:\n\n", 'ISO-8859-1', 'UTF-8'));
$pdf->MultiCell(0, 7, mb_convert_encoding("- Competencia en Lectura y Escritura: $competencia_lectoescritura\n- Matemáticas Básicas: $matematica_basica\n- Habilidades de Organización: $habilidades_organizacionales", 'ISO-8859-1', 'UTF-8'));

// Recomendación
$pdf->Ln(10);
$pdf->MultiCell(0, 7, mb_convert_encoding("4. Recomendación:\n\n$recomendaciones", 'ISO-8859-1', 'UTF-8'));

// Observaciones Finales
$pdf->Ln(10);
$pdf->MultiCell(0, 7, mb_convert_encoding("5. Observaciones Finales:\n\n$observaciones", 'ISO-8859-1', 'UTF-8'));

// Mostrar o descargar el PDF
$pdf->Output('I', 'Informe_' . $nombre_completo . '.pdf');

// Cerrar la conexión a la base de datos
$conn->close();

// Limpiar el búfer de salida
ob_end_flush();
?>
