<?php
// generate_pdf.php

require('fpdf/fpdf.php');
include 'db_config.php';

// Obtener los parámetros de la URL
$beneficiario_id = isset($_GET['beneficiario_id']) ? intval($_GET['beneficiario_id']) : 0;
$period = isset($_GET['period']) ? $_GET['period'] : '';

// Validar parámetros
if ($beneficiario_id <= 0 || empty($period)) {
    die("Parámetros inválidos.");
}

// Obtener la información del beneficiario
$stmt = $conn->prepare("SELECT * FROM beneficiarios WHERE id = ?");
if (!$stmt) {
    die("Error en la preparación de la consulta: " . $conn->error);
}

$stmt->bind_param("i", $beneficiario_id);
$stmt->execute();
$result_beneficiario = $stmt->get_result();

if ($result_beneficiario->num_rows == 0) {
    die("Beneficiario no encontrado.");
}

$beneficiario = $result_beneficiario->fetch_assoc();
$stmt->close();

// Definir el rango de fechas basado en el período seleccionado
switch ($period) {
    case 'ultima':
        $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? ORDER BY fecha_evaluacion DESC LIMIT 1";
        break;
    case 'mensual':
        $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND fecha_evaluacion >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH) ORDER BY fecha_evaluacion DESC";
        break;
    case 'trimestral':
        $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND fecha_evaluacion >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH) ORDER BY fecha_evaluacion DESC";
        break;
    case 'semestral':
        $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND fecha_evaluacion >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH) ORDER BY fecha_evaluacion DESC";
        break;
    case 'anual':
        $current_year = date('Y');
        $sql_seguimientos = "SELECT * FROM seguimientos WHERE beneficiario_id = ? AND YEAR(fecha_evaluacion) = ? ORDER BY fecha_evaluacion DESC";
        break;
    default:
        die("Período no válido.");
}

// Preparar la consulta de seguimientos
if ($period == 'anual') {
    $stmt_seguimientos = $conn->prepare($sql_seguimientos);
    if (!$stmt_seguimientos) {
        die("Error en la preparación de la consulta: " . $conn->error);
    }
    $stmt_seguimientos->bind_param("ii", $beneficiario_id, $current_year);
} else {
    $stmt_seguimientos = $conn->prepare($sql_seguimientos);
    if (!$stmt_seguimientos) {
        die("Error en la preparación de la consulta: " . $conn->error);
    }
    $stmt_seguimientos->bind_param("i", $beneficiario_id);
}

$stmt_seguimientos->execute();
$result_seguimientos = $stmt_seguimientos->get_result();

if ($result_seguimientos->num_rows == 0) {
    die("No hay seguimientos disponibles para el período seleccionado.");
}

// Inicializar PDF
$pdf = new FPDF();
$pdf->AddPage();

// Mostrar información del beneficiario una sola vez
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 10, mb_convert_encoding('IDENTIFICACIÓN', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->Ln(10);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, mb_convert_encoding('Nombre:', 'ISO-8859-1', 'UTF-8'), 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, mb_convert_encoding($beneficiario['nombre_completo'], 'ISO-8859-1', 'UTF-8'), 1, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, mb_convert_encoding('Documento ID:', 'ISO-8859-1', 'UTF-8'), 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, mb_convert_encoding($beneficiario['documento_identidad'], 'ISO-8859-1', 'UTF-8'), 1, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, mb_convert_encoding('Fecha Nac:', 'ISO-8859-1', 'UTF-8'), 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, mb_convert_encoding($beneficiario['fecha_nacimiento'], 'ISO-8859-1', 'UTF-8'), 1, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, mb_convert_encoding('Correo:', 'ISO-8859-1', 'UTF-8'), 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, mb_convert_encoding($beneficiario['correo_electronico'], 'ISO-8859-1', 'UTF-8'), 1, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, mb_convert_encoding('Acudiente:', 'ISO-8859-1', 'UTF-8'), 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, mb_convert_encoding($beneficiario['acudiente'], 'ISO-8859-1', 'UTF-8'), 1, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, mb_convert_encoding('Institución:', 'ISO-8859-1', 'UTF-8'), 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, mb_convert_encoding($beneficiario['institucion_patrocinadora'], 'ISO-8859-1', 'UTF-8'), 1, 1);

// Agregar fotografía del beneficiario
$photo_path = "uploads/fotos/" . $beneficiario['fotografia'];
if (!empty($beneficiario['fotografia']) && file_exists($photo_path)) {
    list($width, $height) = getimagesize($photo_path);

    // Definir dimensiones máximas para la imagen
    $max_width = 50;
    $max_height = 50;

    if ($width > $max_width || $height > $max_height) {
        $aspect_ratio = $width / $height;

        if ($width > $max_width) {
            $width = $max_width;
            $height = $width / $aspect_ratio;
        }

        if ($height > $max_height) {
            $height = $max_height;
            $width = $height * $aspect_ratio;
        }
    }

    $pdf->Image($photo_path, 150, 10, $width, $height);
} else {
    $pdf->Cell(0, 10, mb_convert_encoding('No se encontró la fotografía del beneficiario.', 'ISO-8859-1', 'UTF-8'), 0, 1);
}

$pdf->Ln(10);

// Agregar título de seguimientos
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, mb_convert_encoding('REPORTE INSTITUCIONAL', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
$pdf->Ln(5);
$pdf->Cell(0, 10, mb_convert_encoding(ucfirst($period), 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

// Detalles de los seguimientos
$pdf->SetFont('Arial', '', 11);
while ($seguimiento = $result_seguimientos->fetch_assoc()) {
    $pdf->Cell(17, 5, mb_convert_encoding('Fecha', 'ISO-8859-1', 'UTF-8'), 1);
    $pdf->Cell(24, 5, mb_convert_encoding($seguimiento['fecha_evaluacion'], 'ISO-8859-1', 'UTF-8'), 1);
    $pdf->Cell(20, 5, mb_convert_encoding('Evaluador', 'ISO-8859-1', 'UTF-8'), 1);
    $pdf->Cell(65, 5, mb_convert_encoding($seguimiento['evaluador'], 'ISO-8859-1', 'UTF-8'), 1);
    $pdf->Cell(25, 5, mb_convert_encoding('Asignatura', 'ISO-8859-1', 'UTF-8'), 1);
    $pdf->Cell(35, 5, mb_convert_encoding($seguimiento['asignatura'], 'ISO-8859-1', 'UTF-8'), 1);
    $pdf->Ln(5);

    // Seguimiento
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(0, 10, mb_convert_encoding('SEGUIMIENTO', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
    $apreciacion = substr($seguimiento['apreciacion'], 0, 5000);
    $pdf->MultiCell(185, 10, mb_convert_encoding($apreciacion, 'ISO-8859-1', 'UTF-8'), 1);


  // Objetivos
    $pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, mb_convert_encoding( 'OBJETIVOS DEL PERIODO','ISO-8859-1', 'UTF-8'), 0, 1, 'C');
    // $pdf->Cell(40, 10, 'Seguimiento', 1);
    $objetivos = substr($seguimiento['objetivos'], 0, 5000); // Ajustar si es necesario
    $pdf->MultiCell(185, 10, mb_convert_encoding($objetivos, 'ISO-8859-1', 'UTF-8'), 1);   
    
    // Ajustes Razonables
        $pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, mb_convert_encoding('AJUSTES RAZONABLES','ISO-8859-1', 'UTF-8'), 0, 1, 'C');
    //$pdf->Cell(40, 10, 'Ajustes Razonables', 1);
    $ajustes_razonables = substr($seguimiento['ajustes_razonables'], 0, 5000); // Ajustar si es necesario
    $pdf->MultiCell(185, 10, mb_convert_encoding( $ajustes_razonables, 'ISO-8859-1', 'UTF-8'), 1);
    
    // Plan de Acción
        $pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10,mb_convert_encoding( 'PLAN DE ACCION','ISO-8859-1', 'UTF-8'), 0, 1, 'C');
    //$pdf->Cell(40, 10, 'Plan de Acción', 1);
    $plan_accion = substr($seguimiento['plan_accion'], 0, 5000); // Ajustar si es necesario
    $pdf->MultiCell(185, 10, mb_convert_encoding( $plan_accion, 'ISO-8859-1', 'UTF-8'), 1);

    // Añadir espacio entre seguimientos
    $pdf->Ln(10);
}

$pdf->Output('D', 'reporte_seguimiento_' . $beneficiario['nombre_completo'] . '.pdf');

$stmt_seguimientos->close();
$conn->close();
 // cierra el else
?>
