<?php
// archivo get_evolutionIndCueAut_data.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
// Obtener el ID del usuario de forma segura
$user_id = "";
if (!empty($_GET['id'])) {
    $user_id = $conn->real_escape_string($_GET['id']);
} elseif (!empty($_GET['user_id'])) {
    $user_id = $conn->real_escape_string($_GET['user_id']);
}

// Si no se recibió un ID de usuario válido, se detiene la ejecución
if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido.");
    echo json_encode([]);
    exit();
}

// Verificar si la columna 'documento_identidad' existe en la tabla 'cuestionarios_satisfaccion'
$checkColumnQuery = "SHOW COLUMNS FROM cuestionarios_satisfaccion LIKE 'documento_identidad'";
$columnExists = ($conn->query($checkColumnQuery)->num_rows > 0);

// Arreglo para almacenar la información agrupada por mes.
$data = [];

/**
 * Función para procesar una tabla y obtener datos de evolución.
 */
function processTable(mysqli $conn, string $table, string $dateColumn, string $puntajeColumn, string $testName, bool $columnExists, string $user_id): void {
    global $data;

    // Determinar la condición de usuario según la existencia de la columna 'documento_identidad'
    $user_condition = "WHERE participant_id = '$user_id'";
    if ($columnExists && $table === "cuestionarios_satisfaccion") {
        $user_condition = "WHERE documento_identidad = '$user_id'";
    }

    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
                   SUM($puntajeColumn) AS total_aciertos, 
                   COUNT(*) AS total_tests 
            FROM $table $user_condition 
            GROUP BY mes 
            ORDER BY mes ASC";

    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_aciertos' => (int)$row['total_aciertos'],
                'total_tests'    => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}

// Procesar las preguntas del cuestionario de satisfacción
processTable($conn, 'cuestionarios_satisfaccion', 'fecha_registro', 'bienestar_post', 'pregunta1', $columnExists, $user_id);
processTable($conn, 'cuestionarios_satisfaccion', 'fecha_registro', 'motivacion_post', 'pregunta2', $columnExists, $user_id);

// Verificar si $data quedó vacío y registrar un mensaje de error si es necesario
if (empty($data)) {
    error_log("No se obtuvieron datos. Verifica que la tabla contenga registros y que las columnas de fecha y puntaje tengan valores válidos.");
}

// Ordenar por mes y formatear la salida final
ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes] + $tests;
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>