<?php
// archivo get_evolutionIndHabAcaBas_data.php
header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Filtrar por usuario (ID del participante)
$user_id = "";
if (!empty($_GET['id'])) {
    $user_id = $conn->real_escape_string($_GET['id']);
} elseif (!empty($_GET['user_id'])) {
    $user_id = $conn->real_escape_string($_GET['user_id']);
}

// Si no se recibió un ID de usuario, se detiene la ejecución para evitar extraer todos los datos
if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido.");
    echo json_encode([]);
    exit();
}

// Verificar si la columna 'documento_identidad' existe en la tabla 'escritura'
$checkColumnQuery = "SHOW COLUMNS FROM escritura LIKE 'participant_id'";
$columnExists = ($conn->query($checkColumnQuery)->num_rows > 0);

// Arreglo para almacenar la información agrupada por mes.
$data = [];

/**
 * Procesa los datos de una tabla agrupados por mes.
 *
 * Realiza una consulta que agrupa los registros por mes (formateado como 'YYYY-MM') y obtiene la suma de score y el total de registros.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $dateColumn Columna de fecha.
 * @param string $scoreColumn Columna de score.
 * @param string $testName Identificador del test.
 * @param bool $columnExists Indica si la columna 'documento_identidad' existe.
 * @param string $user_id ID del usuario.
 */
function processTable(mysqli $conn, string $table, string $dateColumn, string $scoreColumn, string $testName, bool $columnExists, string $user_id): void {
    global $data;
    
    // Utilizar siempre la condición por participant_id
    $user_condition = "WHERE participant_id = '$user_id'";
    // Si se desea usar 'documento_identidad' en la tabla escritura, se podría activar la siguiente línea:
    // if ($columnExists && $table === "escritura") { $user_condition = "WHERE documento_identidad = '$user_id'"; }
    
    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
                   SUM($scoreColumn) AS total_score, 
                   COUNT(*) AS total_tests 
            FROM $table 
            $user_condition
            GROUP BY mes 
            ORDER BY mes ASC";
            
    error_log("Ejecutando SQL: $sql");
            
    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_score' => (int)$row['total_score'],
                'total_tests' => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}

// Procesar cada tabla (usando nombres de tabla sin acento en 'lectura_comprensión')
processTable($conn, 'lectura_comprensión', 'fecha_registro', 'score', 'lectura_comprensión', $columnExists, $user_id);
processTable($conn, 'escritura', 'fecha_registro', 'score', 'escritura', $columnExists, $user_id);
processTable($conn, 'matematicas_basicas', 'fecha_registro', 'score', 'matematicas_basicas', $columnExists, $user_id);

if (empty($data)) {
    error_log("No se obtuvieron datos. Verifica que las tablas contengan registros y que las columnas de fecha y score tengan valores válidos.");
}

ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes] + $tests;
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>
