<?php
// archivo get_evolutionIndHabDan_data.php

header('Content-Type: application/json');
include 'db_config.php';

// Filtrar por usuario (ID del participante)
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    // Se prioriza 'id' ya que en el HTML se envía como "id"
    $user_id = $conn->real_escape_string(isset($_GET['id']) ? $_GET['id'] : $_GET['user_id']);
}

// Si no se recibió un ID de usuario, se detiene la ejecución para evitar extraer todos los datos
if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido.");
    echo json_encode([]);
    exit();
}

// Verificar si la columna 'documento_identidad' existe en la tabla
$checkColumnQuery = "SHOW COLUMNS FROM danza_expresion_corporal LIKE 'documento_identidad'";
$columnExists = $conn->query($checkColumnQuery)->num_rows > 0;

// Arreglo para almacenar la información agrupada por mes.
$data = [];

function processTable(mysqli $conn, string $table, string $dateColumn, string $puntajeColumn, string $testName, bool $columnExists): void {
    global $data, $user_id;
    
    $user_condition = " WHERE participant_id = '$user_id' ";
    if ($columnExists && $table === "danza_expresion_corporal") {
        $user_condition = " WHERE documento_identidad = '$user_id' ";
    }

    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
               SUM($puntajeColumn) AS total_aciertos, 
               COUNT(*) AS total_tests 
        FROM $table $user_condition
        GROUP BY mes 
        ORDER BY mes ASC";

    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_aciertos' => (int)$row['total_aciertos'],
                'total_tests'    => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}

// Procesar cada campo de la tabla 'danza_expresion_corporal'
processTable($conn, 'danza_expresion_corporal', 'fecha_registro', 'puntaje_coordinacion', 'pregunta1', $columnExists);
processTable($conn, 'danza_expresion_corporal', 'fecha_registro', 'puntaje_equilibrio', 'pregunta2', $columnExists);
processTable($conn, 'danza_expresion_corporal', 'fecha_registro', 'puntaje_control_corporal', 'pregunta3', $columnExists);
processTable($conn, 'danza_expresion_corporal', 'fecha_registro', 'puntaje_espontaneidad', 'pregunta4', $columnExists);
processTable($conn, 'danza_expresion_corporal', 'fecha_registro', 'puntaje_creatividad', 'pregunta5', $columnExists);

// Verificar si $data quedó vacío
if (empty($data)) {
    error_log("No se obtuvieron datos. Verifica que la tabla contenga registros y que las columnas de fecha y puntaje tengan valores válidos.");
}

ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes];
    foreach ($tests as $testKey => $values) {
        $entry[$testKey] = $values;
    }
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>
