<?php
// archivo get_evolutionIndHabDibPin_data.php

header('Content-Type: application/json');
include 'db_config.php';

// Filtrar por usuario (ID del participante)
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    // Se prioriza 'id' ya que en el HTML se envía como "id"
    $user_id = $conn->real_escape_string(isset($_GET['id']) ? $_GET['id'] : $_GET['user_id']);
}

// Si no se recibió un ID de usuario, se detiene la ejecución para evitar extraer todos los datos
if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido.");
    echo json_encode([]);
    exit();
}

// Arreglo para almacenar la información agrupada por mes.
$data = [];

/**
 * Procesa los datos de una tabla agrupados por mes.
 *
 * Realiza una consulta que agrupa los registros por mes (formateado como 'YYYY-MM') y obtiene la suma del puntaje y el total de registros.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $dateColumn Nombre de la columna que contiene la fecha.
 * @param string $puntajeColumn Nombre de la columna que contiene el puntaje.
 * @param string $testName Identificador del test para indexar los resultados.
 * @return void
 */
function processTable(mysqli $conn, string $table, string $dateColumn, string $puntajeColumn, string $testName): void {
    global $data, $user_id;
    
    $user_condition = "";
    if ($user_id !== "") {
        if ($table === "dibujo_pintura") {
            $user_condition = " WHERE documento_identidad = '$user_id' ";
        } else {
            $user_condition = " WHERE participant_id = '$user_id' ";
        }
    }
    
    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
                   SUM($puntajeColumn) AS total_aciertos, 
                   COUNT(*) AS total_tests 
            FROM $table $user_condition
            GROUP BY mes 
            ORDER BY mes ASC";

    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_aciertos' => (int)$row['total_aciertos'],
                'total_tests'    => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}

// Procesar cada campo de la tabla 'dibujo_pintura'
// Se asignan claves para que coincidan con lo que espera el JavaScript: pregunta1, pregunta2 y pregunta3.
processTable($conn, 'dibujo_pintura', 'fecha_registro', 'puntaje_precision', 'pregunta1');
processTable($conn, 'dibujo_pintura', 'fecha_registro', 'puntaje_colores', 'pregunta2');
processTable($conn, 'dibujo_pintura', 'fecha_registro', 'puntaje_organizacion', 'pregunta3');

// Verificar si $data quedó vacío
if (empty($data)) {
    error_log("No se obtuvieron datos. Verifica que la tabla contenga registros y que las columnas de fecha y puntaje tengan valores válidos.");
}

ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes];
    foreach ($tests as $testKey => $values) {
        $entry[$testKey] = $values;
    }
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>
