<?php
// archivo get_evolutionIndIndCogTarAca_data.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Obtener el ID del usuario (priorizando 'id' sobre 'user_id')
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string(isset($_GET['id']) ? $_GET['id'] : $_GET['user_id']);
}

if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido (IndIndCogTarAca Evolution).");
    echo json_encode([]);
    exit();
}

$data = [];

/**
 * Procesa los datos de una tabla agrupados por mes.
 *
 * Agrupa los registros por mes (formateado como 'YYYY-MM') y obtiene la suma de aciertos y el total de registros.
 *
 * @param mysqli $conn Conexión a la BD.
 * @param string $table Nombre de la tabla.
 * @param string $dateColumn Columna de fecha.
 * @param string $aciertosColumn Columna que contiene los aciertos.
 * @param string $testName Identificador del test.
 */
function processTable(mysqli $conn, string $table, string $dateColumn, string $aciertosColumn, string $testName): void {
    global $data, $user_id;
    
    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
                   SUM($aciertosColumn) AS total_aciertos, 
                   COUNT(*) AS total_tests 
            FROM $table 
            WHERE participant_id = '$user_id'
            GROUP BY mes 
            ORDER BY mes ASC";
    
    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_aciertos' => (int)$row['total_aciertos'],
                'total_tests'    => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}

// Procesar cada tabla (de acuerdo a la estructura de tus datos)
// Aquí se asume que tienes tres áreas para esta categoría:
processTable($conn, 'atencion_concentracion', 'fecha_registro', 'aciertos', 'atencion_concentracion');
processTable($conn, 'resolucion_problemas', 'fecha_registro', 'aciertos', 'resolucion_problemas');
processTable($conn, 'resultados_retencion', 'fecha_registro', 'aciertos', 'resultados_retencion');

if (empty($data)) {
    error_log("No se obtuvieron datos para el usuario $user_id en IndIndCogTarAca Evolution.");
}

ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes] + $tests;
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>
