<?php
// archivo get_evolutionIndObsReg_data.php
header('Content-Type: application/json');
include 'db_config.php';

// Filtrar por usuario (ID del participante)
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string(isset($_GET['id']) ? $_GET['id'] : $_GET['user_id']);
}

// Arreglo para almacenar la información agrupada por mes.
$data = [];

/**
 * Procesa los datos de la tabla 'evaluacion_impacto' agrupados por mes.
 *
 * Realiza una consulta que agrupa los registros por mes (formateado como 'YYYY-MM') y obtiene la suma de la pregunta y el total de registros,
 * filtrando solo los datos del usuario indicado.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla (evaluacion_impacto).
 * @param string $dateColumn Columna de fecha.
 * @param string $preguntaColumn Columna de la pregunta (pregunta1, pregunta2, …).
 * @param string $testName Identificador para indexar el resultado.
 */
function processTable(mysqli $conn, string $table, string $dateColumn, string $preguntaColumn, string $testName): void {
    global $data, $user_id;
    
// Si se ha recibido un id, se filtra por participant_id; de lo contrario, no se filtra.
    $user_condition = "";
    if (!empty($user_id)) {
        $user_condition = "WHERE participant_id = '$user_id'";
    }

    // Se agrega la condición para filtrar por participant_id
    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
                   SUM($preguntaColumn) AS total_pregunta, 
                   COUNT(*) AS total_tests 
            FROM $table 
            $user_condition
            GROUP BY mes 
            ORDER BY mes ASC";

    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_pregunta' => (int)$row['total_pregunta'],
                'total_tests'    => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}

// Procesar cada pregunta (1 a 10) de la tabla evaluacion_impacto
for ($i = 1; $i <= 10; $i++) {
    $preguntaColumn = 'pregunta' . $i;
    $testName = 'evaluacion_impacto_pregunta' . $i;
    processTable($conn, 'evaluacion_impacto', 'fecha_registro', $preguntaColumn, $testName);
}

ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes];
    foreach ($tests as $testName => $values) {
        $entry[$testName] = $values;
    }
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>
