<?php
// archivo get_evolutionIndObs_data.php

header('Content-Type: application/json');
include 'db_config.php';

// Arreglo para almacenar la información agrupada por mes.
$data = [];

/**
 * Procesa los datos de una tabla agrupados por mes.
 *
 * Realiza una consulta que agrupa los registros por mes (formateado como 'YYYY-MM') y obtiene la suma de pregunta y el total de registros.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $dateColumn Nombre de la columna que contiene la fecha.
 * @param string $preguntaColumn Nombre de la columna que contiene los pregunta.
 * @param string $testName Identificador del test para indexar los resultados.
 * @return void
 */
function processTable(mysqli $conn, string $table, string $dateColumn, string $preguntaColumn, string $testName): void {
    global $data;

    // Preparar la consulta SQL que agrupa por mes.
    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
                   SUM($preguntaColumn) AS total_pregunta, 
                   COUNT(*) AS total_tests 
            FROM $table 
            GROUP BY mes 
            ORDER BY mes ASC";

    // Ejecutar la consulta y validar su ejecución.
    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_pregunta' => (int)$row['total_pregunta'],
                'total_tests'    => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        // Registrar error con información adicional
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}


// Procesar cada pregunta de la tabla 'evaluacion_impacto'
for ($i = 1; $i <= 10; $i++) {
    $preguntaColumn = 'pregunta' . $i;
    $testName = 'evaluacion_impacto_pregunta' . $i;
    processTable($conn, 'evaluacion_impacto', 'fecha_registro', $preguntaColumn, $testName);
}

// Verificar si $data quedó vacío (sin registros)
if (empty($data)) {
    error_log("No se obtuvieron datos. Verifica que las tablas contengan registros y que las columnas de fecha y pregunta tengan valores válidos.");
}

// Transformar el arreglo asociativo en un arreglo de objetos ordenados por mes.
ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes];
    foreach ($tests as $testName => $values) {
        $entry[$testName] = $values;
    }
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>
