<?php
// archivo get_evolutionInd_data.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Obtener el ID del usuario de forma segura
$user_id = "";
if (!empty($_GET['id'])) {
    $user_id = $conn->real_escape_string($_GET['id']);
} elseif (!empty($_GET['user_id'])) {
    $user_id = $conn->real_escape_string($_GET['user_id']);
}

// Si no se recibió un ID de usuario, detener la ejecución para evitar extraer todos los datos
if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido.");
    echo json_encode([]);
    exit();
}

// Verificar si la columna 'participant_id' existe en la tabla 'funciones_ejecutivas'
$checkColumnQuery = "SHOW COLUMNS FROM funciones_ejecutivas LIKE 'participant_id'";
$columnExists = ($conn->query($checkColumnQuery)->num_rows > 0);

// Arreglo para almacenar la información agrupada por mes.
$data = [];

/**
 * Procesa los datos de una tabla agrupados por mes.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $dateColumn Columna de fecha.
 * @param string $aciertosColumn Columna de aciertos.
 * @param string $testName Identificador del test.
 * @param bool $columnExists Indica si la columna 'participant_id' existe.
 * @param string $user_id ID del usuario.
 */
function processTable(mysqli $conn, string $table, string $dateColumn, string $aciertosColumn, string $testName, bool $columnExists, string $user_id): void {
    global $data;
    
    // Determinar la condición de usuario
    $user_condition = "WHERE participant_id = '$user_id'";
    if ($columnExists && $table === "funciones_ejecutivas") {
        // Si en la tabla funciones_ejecutivas se utiliza 'documento_identidad' en vez de 'participant_id'
    }
    
    $sql = "SELECT DATE_FORMAT($dateColumn, '%Y-%m') AS mes, 
                   SUM($aciertosColumn) AS total_aciertos, 
                   COUNT(*) AS total_tests 
            FROM $table 
            $user_condition
            GROUP BY mes 
            ORDER BY mes ASC";
            
    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $mes = $row['mes'];
            if (!isset($data[$mes])) {
                $data[$mes] = [];
            }
            $data[$mes][$testName] = [
                'total_aciertos' => (int)$row['total_aciertos'],
                'total_tests'    => (int)$row['total_tests']
            ];
        }
        $result->free();
    } else {
        error_log("Error en la consulta para la tabla '$table' con SQL [$sql]: " . $conn->error);
    }
}

// Procesar cada tabla de datos
processTable($conn, 'test_entries', 'created_at', 'aciertos', 'test_entries', $columnExists, $user_id);
processTable($conn, 'funciones_ejecutivas', 'fecha_registro', 'aciertos', 'funciones_ejecutivas', $columnExists, $user_id);
processTable($conn, 'atencion_velocidad_procesamiento', 'fecha_registro', 'aciertos', 'atencion_velocidad_procesamiento', $columnExists, $user_id);
processTable($conn, 'visuoespacial_results', 'fecha_registro', 'aciertos', 'visuoespacial_results', $columnExists, $user_id);

if (empty($data)) {
    error_log("No se obtuvieron datos. Verifica que las tablas contengan registros y que las columnas de fecha y aciertos tengan valores válidos.");
}

// Ordenar por mes y formatear la salida final
ksort($data);
$finalData = [];
foreach ($data as $mes => $tests) {
    $entry = ['mes' => $mes] + $tests;
    $finalData[] = $entry;
}

echo json_encode($finalData);
?>
