<?php
// Archivo: get_lineAnaEstDesAteConChartData.php
header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Modalidades específicas (en minúsculas y sin acentos)
$validModalities = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Inicializamos los arreglos para la gráfica de líneas y para la gráfica de torta.
$lineData = [
    "baja intensidad y equilibrio" => [],
    "resistencia moderada"          => [],
    "aerobicos adaptados"           => [],
    "ninguna"                       => []
];
$pieData = [
    "baja intensidad y equilibrio" => 0,
    "resistencia moderada"          => 0,
    "aerobicos adaptados"           => 0,
    "ninguna"                       => 0
];

// La consulta usa REPLACE para eliminar la tilde en la "ó"
$sql = "SELECT 
            REPLACE(LOWER(TRIM(modalidad_deporte)),'ó','o') AS modality,
            DATE_FORMAT(fecha_registro, '%Y-%m') AS mes,
            SUM(aciertos) AS total_aciertos
        FROM atencion_concentracion
        GROUP BY REPLACE(LOWER(TRIM(modalidad_deporte)),'ó','o'), mes
        ORDER BY mes ASC, modality ASC";

$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $mod = trim($row['modality']);
        // Si la modalidad normalizada no es válida, asignamos "ninguna"
        if (!in_array($mod, $validModalities)) {
            $mod = "ninguna";
        }
        $mes = $row['mes'];
        $total = (int)$row['total_aciertos'];
        
        // Acumular para la gráfica de líneas
        if (!isset($lineData[$mod][$mes])) {
            $lineData[$mod][$mes] = 0;
        }
        $lineData[$mod][$mes] += $total;
        
        // Acumular para la gráfica de torta
        $pieData[$mod] += $total;
    }
} else {
    die("Error en la consulta: " . $conn->error);
}
$conn->close();

$output = [
    "lineData" => $lineData,
    "pieData"  => $pieData
];

echo json_encode($output);
?>
