<?php
// archivo get_lineAnaEstDesAteVelProChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Definir las 4 tablas y la columna de fecha a usar para agrupar.
$tables = [
  ['name' => 'atencion_velocidad_procesamiento', 'date' => 'fecha_registro']
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Arreglo para almacenar la información agrupada por modalidad y mes.
$data = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    $dateColumn = $table['date'];
    
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, DATE_FORMAT($dateColumn, '%Y-%m') AS mes, SUM(aciertos) AS total_aciertos
            FROM $tableName
            GROUP BY modality, mes
            ORDER BY modality, mes ASC";
    
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()) {
        $mod = $row['modality'];
        // Normalizar modalidad (eliminar acentos)
        $modNormalized = removeAccents($mod);
        // Si no es una de las específicas, agrupar en "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        $mes = $row['mes'];
        if (!isset($data[$modNormalized])) {
            $data[$modNormalized] = [];
        }
        if (!isset($data[$modNormalized][$mes])) {
            $data[$modNormalized][$mes] = 0;
        }
        $data[$modNormalized][$mes] += (int)$row['total_aciertos'];
    }
}
$conn->close();
echo json_encode($data);
?>
