<?php
// archivo: get_lineAnaEstDesBieMotChartData.php

header('Content-Type: application/json');
include 'db_config.php';

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados" // sin acento
];

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir los nombres para cada indicador
$questionNames = [
    1 => "Bienestar",
    2 => "Motivación"
];

// Inicializamos el arreglo de datos para cada indicador usando los nombres definidos
$data = [];
foreach ($questionNames as $index => $name) {
    $data[$name] = [];
}

// Consulta SQL: Se agrupa por modalidad y mes (formato YYYY-MM)
// Se suma la puntuación de cada indicador por registro
$sql = "SELECT 
            LOWER(TRIM(modalidad_deporte)) AS modality,
            DATE_FORMAT(fecha_registro, '%Y-%m') AS mes,
            SUM(bienestar_post) AS sum_p1,
            SUM(motivacion_post) AS sum_p2
        FROM cuestionarios_satisfaccion
        GROUP BY modality, mes
        ORDER BY mes ASC, modality ASC";

$result = $conn->query($sql);

while ($row = $result->fetch_assoc()) {
    $mod = $row['modality'];
    // Normalizar modalidad: quitar acentos
    $modNormalized = removeAccents($mod);
    // Si la modalidad no es una de las específicas, asignar "ninguna"
    if (!in_array($modNormalized, $modalitiesSpecific)) {
        $modNormalized = "ninguna";
    }
    $mes = $row['mes'];
    
    // Para cada indicador, guardar la sumatoria por mes y modalidad
    for ($i = 1; $i <= 2; $i++) {
        $questionName = $questionNames[$i];
        if (!isset($data[$questionName][$modNormalized])) {
            $data[$questionName][$modNormalized] = [];
        }
        if (!isset($data[$questionName][$modNormalized][$mes])) {
            $data[$questionName][$modNormalized][$mes] = 0;
        }
        $data[$questionName][$modNormalized][$mes] += (int)$row["sum_p$i"];
    }
}

$conn->close();
echo json_encode($data);
?>
