<?php
// archivo: get_lineAnaEstDesGloMotComChartData.php

header('Content-Type: application/json');
include 'db_config.php';

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados" // sin acento
];

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir los nombres para cada "pregunta" (planos)
$questionNames = [
    1 => "Participación",
    2 => "Atención",
    3 => "Desafios",
    4 => "Aprender",
    5 => "Compañerismo",
    6 => "Actitud",
    7 => "Resolutividad",
    8 => "Organización",
    9 => "Resiliencia",
    10 => "Responsabilidad"
];

// Inicializamos el arreglo de datos para cada plano (de 1 a 10) usando los nombres definidos
$data = [];
foreach ($questionNames as $index => $name) {
    $data[$name] = [];
}

// Consulta SQL: Se agrupa por modalidad y por mes (formato YYYY-MM)
// Se suma la puntuación de cada pregunta por registro
$sql = "SELECT 
            LOWER(TRIM(modalidad_deporte)) AS modality,
            DATE_FORMAT(fecha_registro, '%Y-%m') AS mes,
            SUM(pregunta1) AS sum_p1,
            SUM(pregunta2) AS sum_p2,
            SUM(pregunta3) AS sum_p3,
            SUM(pregunta4) AS sum_p4,
            SUM(pregunta5) AS sum_p5,
            SUM(pregunta6) AS sum_p6,
            SUM(pregunta7) AS sum_p7,
            SUM(pregunta8) AS sum_p8,
            SUM(pregunta9) AS sum_p9,
            SUM(pregunta10) AS sum_p10
        FROM evaluacion_impacto
        GROUP BY modality, mes
        ORDER BY mes ASC, modality ASC";

$result = $conn->query($sql);

while ($row = $result->fetch_assoc()) {
    $mod = $row['modality'];
    // Normalizar modalidad: quitar acentos
    $modNormalized = removeAccents($mod);
    // Si la modalidad no es una de las específicas, asignar "ninguna"
    if (!in_array($modNormalized, $modalitiesSpecific)) {
        $modNormalized = "ninguna";
    }
    $mes = $row['mes'];
    
    // Para cada pregunta, guardar la sumatoria por mes y modalidad
    for ($i = 1; $i <= 10; $i++) {
        $questionName = $questionNames[$i];
        // Inicializar el arreglo para la modalidad si no existe
        if (!isset($data[$questionName][$modNormalized])) {
            $data[$questionName][$modNormalized] = [];
        }
        // Si ya existe dato para ese mes, se suma (por si hay más de un registro para esa agrupación)
        if (!isset($data[$questionName][$modNormalized][$mes])) {
            $data[$questionName][$modNormalized][$mes] = 0;
        }
        $data[$questionName][$modNormalized][$mes] += (int)$row["sum_p$i"];
    }
}

$conn->close();
echo json_encode($data);
?>
