<?php
// archivo get_lineAnaEstDesGlobHabAcaBasChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Modalidades válidas (en minúsculas)
$validModalities = ["baja intensidad y equilibrio", "resistencia moderada", "aerobicos adaptados"];

// Definimos los nombres de cada prueba (test)
$tests = [
    "lectura_comprensión",
    "escritura",
    "matematicas_basicas",
    
];

// Inicializamos la estructura para los datos de línea:
// Para cada test, se crea un arreglo por modalidad (las 3 específicas y "ninguna")
$lineData = [];
foreach ($tests as $test) {
    $lineData[$test] = [
        "baja intensidad y equilibrio" => [],
        "resistencia moderada"          => [],
        "aeróbicos adaptados"           => [],
        "ninguna"                     => []
    ];
}

// Inicializamos la estructura para la gráfica de torta (acumulados totales)
$pieData = [
    "baja intensidad y equilibrio" => [
         "lectura_comprensión" => 0,
         "escritura" => 0,
         "matematicas_basicas" => 0
    ],
    "resistencia moderada" => [
         "lectura_comprensión" => 0,
         "escritura" => 0,
         "matematicas_basicas" => 0
    ],
    "aeróbicos adaptados" => [
         "lectura_comprensión" => 0,
         "escritura" => 0,
         "matematicas_basicas" => 0
    ],
    "ninguna" => [
         "lectura_comprensión" => 0,
         "escritura" => 0,
         "matematicas_basicas" => 0
    ]
];

// Función auxiliar para procesar cada consulta
function processQuery($conn, $query, $testName, &$lineData, &$pieData, $validModalities) {
    $result = $conn->query($query);
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            // Normalizamos la modalidad
            $mod = strtolower(trim($row['modalidad_deporte']));
            if (!in_array($mod, $validModalities)) {
                $mod = "ninguna";
            }
            $month = $row['month'];
            $total = (float)$row['total_aciertos'];
            
            // Acumulamos el total para el gráfico de líneas
            $lineData[$testName][$mod][$month] = $total;
            // Acumulamos el total para la gráfica de torta
            $pieData[$mod][$testName] += $total;
        }
    }
}

// Consulta para la tabla de lectura_comprensión (lectura_comprensión)
$query1 = "SELECT 
              LOWER(TRIM(modalidad_deporte)) AS modalidad_deporte, 
              DATE_FORMAT(fecha_registro, '%Y-%m') AS month,  
              SUM(aciertos) AS total_aciertos 
           FROM lectura_comprensión 
           GROUP BY modalidad_deporte, month";
processQuery($conn, $query1, "lectura_comprensión", $lineData, $pieData, $validModalities);

// Consulta para escritura
$query2 = "SELECT 
              LOWER(TRIM(modalidad_deporte)) AS modalidad_deporte, 
              DATE_FORMAT(fecha_registro, '%Y-%m') AS month,  
              SUM(aciertos) AS total_aciertos 
           FROM escritura 
           GROUP BY modalidad_deporte, month";
processQuery($conn, $query2, "escritura", $lineData, $pieData, $validModalities);

// Consulta para matematicas_basicas
$query3 = "SELECT 
              LOWER(TRIM(modalidad_deporte)) AS modalidad_deporte, 
              DATE_FORMAT(fecha_registro, '%Y-%m') AS month,  
              SUM(aciertos) AS total_aciertos 
           FROM matematicas_basicas 
           GROUP BY modalidad_deporte, month";
processQuery($conn, $query3, "matematicas_basicas", $lineData, $pieData, $validModalities);

$conn->close();

// (Opcional) Ordenamos los meses para cada conjunto
foreach ($lineData as $testName => &$modalidades) {
    foreach ($modalidades as $mod => &$dataByMonth) {
        ksort($dataByMonth);
    }
}

$output = [
    "lineData" => $lineData,
    "pieData"  => $pieData
];

echo json_encode($output);
?>
