<?php
// archivo get_lineAnaEstDesGlobRenCogChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Modalidades válidas (en minúsculas y sin acentos)
$validModalities = ["baja intensidad y equilibrio", "resistencia moderada", "aerobicos adaptados"];

// Definimos los nombres de cada prueba (test)
$tests = [
    "Memoria Verbal",
    "Funciones Ejecutivas",
    "Atención y Velocidad de Procesamiento",
    "Habilidades Visoespaciales"
];

// Inicializamos la estructura para los datos de línea:
// Para cada test, se crea un arreglo por modalidad (las 3 específicas y "ninguna")
$lineData = [];
foreach ($tests as $test) {
    $lineData[$test] = [
        "baja intensidad y equilibrio" => [],
        "resistencia moderada"          => [],
        "aerobicos adaptados"           => [],
        "ninguna"                     => []
    ];
}

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Inicializamos la estructura para la gráfica de torta (acumulados totales)
$pieData = [
    "baja intensidad y equilibrio" => [
         "Memoria Verbal" => 0,
         "Funciones Ejecutivas" => 0,
         "Atención y Velocidad de Procesamiento" => 0,
         "Habilidades Visoespaciales" => 0
    ],
    "resistencia moderada" => [
         "Memoria Verbal" => 0,
         "Funciones Ejecutivas" => 0,
         "Atención y Velocidad de Procesamiento" => 0,
         "Habilidades Visoespaciales" => 0
    ],
    "aerobicos adaptados" => [
         "Memoria Verbal" => 0,
         "Funciones Ejecutivas" => 0,
         "Atención y Velocidad de Procesamiento" => 0,
         "Habilidades Visoespaciales" => 0
    ],
    "ninguna" => [
         "Memoria Verbal" => 0,
         "Funciones Ejecutivas" => 0,
         "Atención y Velocidad de Procesamiento" => 0,
         "Habilidades Visoespaciales" => 0
    ]
];

// Función auxiliar para procesar cada consulta
function processQuery($conn, $query, $testName, &$lineData, &$pieData, $validModalities) {
    $result = $conn->query($query);
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            // Normalizamos la modalidad aplicando removeAccents()
            $mod = strtolower(trim(removeAccents($row['modalidad_deporte'])));
            if (!in_array($mod, $validModalities)) {
                $mod = "ninguna";
            }
            $month = $row['month'];
            $total = (float)$row['total_aciertos'];
            
            // Guardamos el total para el gráfico de líneas
            $lineData[$testName][$mod][$month] = $total;
            // Acumulamos el total para la gráfica de torta
            $pieData[$mod][$testName] += $total;
        }
    }
}

// Consulta para la tabla de Memoria Verbal (test_entries)
// Se usa la columna created_at para la fecha
$query1 = "SELECT 
              LOWER(TRIM(modalidad_deporte)) AS modalidad_deporte, 
              DATE_FORMAT(created_at, '%Y-%m') AS month,  
              SUM(aciertos) AS total_aciertos 
           FROM test_entries 
           GROUP BY modalidad_deporte, month";
processQuery($conn, $query1, "Memoria Verbal", $lineData, $pieData, $validModalities);

// Consulta para Funciones Ejecutivas
$query2 = "SELECT 
              LOWER(TRIM(modalidad_deporte)) AS modalidad_deporte, 
              DATE_FORMAT(fecha_registro, '%Y-%m') AS month,  
              SUM(aciertos) AS total_aciertos 
           FROM funciones_ejecutivas 
           GROUP BY modalidad_deporte, month";
processQuery($conn, $query2, "Funciones Ejecutivas", $lineData, $pieData, $validModalities);

// Consulta para Atención y Velocidad de Procesamiento
$query3 = "SELECT 
              LOWER(TRIM(modalidad_deporte)) AS modalidad_deporte, 
              DATE_FORMAT(fecha_registro, '%Y-%m') AS month,  
              SUM(aciertos) AS total_aciertos 
           FROM atencion_velocidad_procesamiento 
           GROUP BY modalidad_deporte, month";
processQuery($conn, $query3, "Atención y Velocidad de Procesamiento", $lineData, $pieData, $validModalities);

// Consulta para Habilidades Visoespaciales
$query4 = "SELECT 
              LOWER(TRIM(modalidad_deporte)) AS modalidad_deporte, 
              DATE_FORMAT(fecha_registro, '%Y-%m') AS month,  
              SUM(aciertos) AS total_aciertos 
           FROM visuoespacial_results 
           GROUP BY modalidad_deporte, month";
processQuery($conn, $query4, "Habilidades Visoespaciales", $lineData, $pieData, $validModalities);

$conn->close();

// (Opcional) Ordenamos los meses para cada conjunto
foreach ($lineData as $testName => &$modalidades) {
    foreach ($modalidades as $mod => &$dataByMonth) {
        ksort($dataByMonth);
    }
}

$output = [
    "lineData" => $lineData,
    "pieData"  => $pieData
];

echo json_encode($output);
?>
