<?php
// get_lineAnaEstDesIndCogTarAcaChartData.php


header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Modalidades válidas (en minúsculas)
$validModalities = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Definimos los tests y sus tablas correspondientes (usando claves que coincidan con el JS)
$tests = [
    "atencion_concentracion" => "atencion_concentracion",
    "resolucion_problemas"  => "resolucion_problemas",
    "resultados_retencion"  => "resultados_retencion"
];

// Inicializamos la estructura para los datos de línea.
// Cada test tendrá, para cada modalidad (las 3 válidas y "ninguna"), un arreglo de datos por mes.
$lineData = [];
foreach ($tests as $testName => $tableName) {
    $lineData[$testName] = [
        "baja intensidad y equilibrio" => [],
        "resistencia moderada"          => [],
        "aerobicos adaptados"           => [],
        "ninguna"                       => []
    ];
}

// Inicializamos la estructura para la gráfica de torta.
// Se estructura por modalidad; para cada modalidad se acumula el total de aciertos por test.
$pieData = [
    "baja intensidad y equilibrio" => ["atencion_concentracion" => 0, "resolucion_problemas" => 0, "resultados_retencion" => 0],
    "resistencia moderada"          => ["atencion_concentracion" => 0, "resolucion_problemas" => 0, "resultados_retencion" => 0],
    "aerobicos adaptados"           => ["atencion_concentracion" => 0, "resolucion_problemas" => 0, "resultados_retencion" => 0],
    "ninguna"                       => ["atencion_concentracion" => 0, "resolucion_problemas" => 0, "resultados_retencion" => 0]
];

// Función auxiliar para procesar cada consulta
function processQuery($conn, $sql, $testName, &$lineData, &$pieData, $validModalities) {
    $result = $conn->query($sql);
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            // Se obtiene la modalidad de la columna alias "modality"
            $mod = strtolower(trim($row['modality']));
            if (!in_array($mod, $validModalities)) {
                $mod = "ninguna";
            }
            $month = $row['month'];
            // Se utiliza la columna 'aciertos'
            $total = (float)$row['total_score'];
            $lineData[$testName][$mod][$month] = $total;
            $pieData[$mod][$testName] += $total;
        }
    }
}

foreach ($tests as $testName => $tableName) {
    // Se utiliza DATE_FORMAT para agrupar por mes (YYYY-MM)
    $sql = "SELECT 
                LOWER(TRIM(modalidad_deporte)) AS modality,
                DATE_FORMAT(fecha_registro, '%Y-%m') AS month,
                SUM(aciertos) AS total_score
            FROM `$tableName`
            GROUP BY modalidad_deporte, month
            ORDER BY month ASC, modalidad_deporte ASC";
    processQuery($conn, $sql, $testName, $lineData, $pieData, $validModalities);
}

$conn->close();

// (Opcional) Ordenar los meses para cada test y modalidad
foreach ($lineData as $testName => &$modalities) {
    foreach ($modalities as $mod => &$dataByMonth) {
        ksort($dataByMonth);
    }
}

$output = [
    "lineData" => $lineData,
    "pieData"  => $pieData
];

echo json_encode($output);
?>
