<?php
// archivo get_lineAnaEstDesMatBasChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Definir las 3 tablas y la columna de fecha a usar para agrupar.
$tables = [
  ['name' => 'matematicas_basicas', 'date' => 'fecha_registro']
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"  // Sin acento
];

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Arreglo para almacenar la información agrupada por modalidad y mes.
$data = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    $dateColumn = $table['date'];
    
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, DATE_FORMAT($dateColumn, '%Y-%m') AS mes, SUM(score) AS total_aciertos
            FROM $tableName
            GROUP BY modality, mes
            ORDER BY modality, mes ASC";
    
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()) {
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        $mes = $row['mes'];
        if (!isset($data[$modNormalized])) {
            $data[$modNormalized] = [];
        }
        if (!isset($data[$modNormalized][$mes])) {
            $data[$modNormalized][$mes] = 0;
        }
        $data[$modNormalized][$mes] += (int)$row['total_aciertos'];
    }
}
$conn->close();
echo json_encode($data);
?>
