<?php
// archivo: get_lineArtesChartData.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Declaramos los nombres de los tests y sus respectivas configuraciones para calcular el promedio
// Cada configuración incluye: 
// - 'table': nombre de la tabla
// - 'numerator': la suma de las columnas de puntaje
// - 'divisor': cantidad de columnas (para calcular el promedio)
$tests = [
    "Dibujo y Pintura" => [
        "table" => "dibujo_pintura",
        "numerator" => "puntaje_precision + puntaje_colores + puntaje_organizacion",
        "divisor" => 3
    ],
    "Escultura y Modelado" => [
        "table" => "escultura_modelado",
        "numerator" => "puntaje_destreza + puntaje_fuerza + puntaje_coordinacion",
        "divisor" => 3
    ],
    "Ritmo y Tempo" => [
        "table" => "ritmo_tempo",
        "numerator" => "puntaje_ritmo + puntaje_tempo",
        "divisor" => 2
    ],
    "Danza y Expresión Corporal" => [
        "table" => "danza_expresion_corporal",
        "numerator" => "puntaje_coordinacion + puntaje_equilibrio + puntaje_control_corporal + puntaje_espontaneidad + puntaje_creatividad",
        "divisor" => 5
    ],
    "Expresión Teatral" => [
        "table" => "expresion_teatral",
        "numerator" => "puntaje_expresion + puntaje_proyectar_voz + puntaje_control_corporal + puntaje_modular_tonos + puntaje_articulacion",
        "divisor" => 5
    ]
];

// Inicializamos el arreglo de datos a devolver. Cada test tendrá su propio objeto.
$data = [];
foreach ($tests as $testName => $conf) {
    $data[$testName] = [];
    // Se estructurará como: modalidad => { mes => promedio, ... }
}

foreach ($tests as $testName => $conf) {
    $table = $conf['table'];
    $numerator = $conf['numerator'];
    $divisor = $conf['divisor'];
    
    // Calculamos el promedio agrupando por modalidad y mes:
    // Usamos COUNT(*) para conocer la cantidad de registros en ese grupo, de modo que el promedio sea:
    // SUM(numerator) / (COUNT(*) * divisor)
    $sql = "SELECT 
                LOWER(TRIM(modalidad_deporte)) AS modality,
                DATE_FORMAT(fecha_registro, '%Y-%m') AS mes,
                SUM($numerator) / (COUNT(*) * $divisor) AS avg_score
            FROM $table
            GROUP BY modality, mes
            ORDER BY mes ASC, modality ASC";
    
    $result = $conn->query($sql);
    if (!$result) {
        die("Error en la consulta de $table: " . $conn->error);
    }
    while ($row = $result->fetch_assoc()) {
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        $mes = $row['mes'];
        $avg = round((float)$row['avg_score'], 2);
        
        if (!isset($data[$testName][$modNormalized])) {
            $data[$testName][$modNormalized] = [];
        }
        $data[$testName][$modNormalized][$mes] = $avg;
    }
}

$conn->close();
echo json_encode($data);
?>
