<?php
//get_lineEducacionChartData.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Modalidades válidas (en minúsculas)
$validModalities = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Definimos los tests y sus tablas correspondientes
$tests = [
    "Comprensión Lectora" => "lectura_comprensión",
    "Escritura"           => "escritura",
    "Matemáticas Básicas" => "matematicas_basicas"
];

// Inicializamos la estructura para los datos de línea.
// Cada test tendrá, para cada modalidad (las 3 válidas y "ninguna"), un arreglo de datos por mes.
$lineData = [];
foreach ($tests as $testName => $tableName) {
    $lineData[$testName] = [
        "baja intensidad y equilibrio" => [],
        "resistencia moderada"          => [],
        "aerobicos adaptados"           => [],
        "ninguna"                       => []
    ];
}

// Inicializamos la estructura para la gráfica de torta.
// Se estructura por modalidad; para cada modalidad se acumula el total de score por test.
$pieData = [
    "baja intensidad y equilibrio" => ["Comprensión Lectora" => 0, "Escritura" => 0, "Matemáticas Básicas" => 0],
    "resistencia moderada"          => ["Comprensión Lectora" => 0, "Escritura" => 0, "Matemáticas Básicas" => 0],
    "aerobicos adaptados"           => ["Comprensión Lectora" => 0, "Escritura" => 0, "Matemáticas Básicas" => 0],
    "ninguna"                       => ["Comprensión Lectora" => 0, "Escritura" => 0, "Matemáticas Básicas" => 0]
];

// Función auxiliar para procesar cada consulta
function processQuery($conn, $sql, $testName, &$lineData, &$pieData, $validModalities) {
    $result = $conn->query($sql);
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $mod = strtolower(trim($row['modality']));
            if (!in_array($mod, $validModalities)) {
                $mod = "ninguna";
            }
            $month = $row['month'];
            //$avg   = (float)$row['avg_score'];
            $total = (float)$row['total_score'];
            $lineData[$testName][$mod][$month] = $total;
            $pieData[$mod][$testName] += $total;
        }
    }
}

foreach ($tests as $testName => $tableName) {
    // Se utiliza DATE_FORMAT para agrupar por mes (YYYY-MM)
    $sql = "SELECT 
                LOWER(TRIM(modalidad_deporte)) AS modality,
                DATE_FORMAT(fecha_registro, '%Y-%m') AS month,
                
                SUM(score) AS total_score
            FROM `$tableName`
            GROUP BY modalidad_deporte, month
            ORDER BY month ASC, modalidad_deporte ASC";
    processQuery($conn, $sql, $testName, $lineData, $pieData, $validModalities);
}

$conn->close();

// (Opcional) Ordenar los meses para cada test y modalidad
foreach ($lineData as $testName => &$modalities) {
    foreach ($modalities as $mod => &$dataByMonth) {
        ksort($dataByMonth);
    }
}

$output = [
    "lineData" => $lineData,
    "pieData"  => $pieData
];

echo json_encode($output);
?>
