<?php

// get_lineMatBasChartData.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Modalidades válidas (en minúsculas)
$validModalities = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Inicializamos dos estructuras:
// - lineData: para cada modalidad, un arreglo: mes => sumatoria de score
// - pieData: acumulado total de score por modalidad
$lineData = [
    "baja intensidad y equilibrio" => [],
    "resistencia moderada"          => [],
    "aerobicos adaptados"           => [],
    "ninguna"                       => []
];
$pieData = [
    "baja intensidad y equilibrio" => 0,
    "resistencia moderada"          => 0,
    "aerobicos adaptados"           => 0,
    "ninguna"                       => 0
];

// Consulta SQL: agrupar por modalidad y mes
$sql = "SELECT 
            LOWER(TRIM(modalidad_deporte)) AS modality,
            DATE_FORMAT(fecha_registro, '%Y-%m') AS month,
            SUM(score) AS total_score 
        FROM matematicas_basicas
        GROUP BY modalidad_deporte, month
        ORDER BY month ASC, modality ASC";

$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $mod = $row['modality'];
        // Si la modalidad no es una de las válidas, se agrupa en "ninguna"
        if (!in_array($mod, $validModalities)) {
            $mod = "ninguna";
        }
        $month = $row['month'];
        $total = (float)$row['total_score'];
        
        // Para el gráfico de líneas: si no existe valor para ese mes, se inicializa
        if (!isset($lineData[$mod][$month])) {
            $lineData[$mod][$month] = 0;
        }
        $lineData[$mod][$month] += $total;
        
        // Para el gráfico de torta: acumular total
        $pieData[$mod] += $total;
    }
} else {
    die("Error en la consulta: " . $conn->error);
}

$conn->close();

$output = [
    "lineData" => $lineData,
    "pieData"  => $pieData
];

echo json_encode($output);
?>
