<?php
// archivo: get_lineRitmoTempoChartData.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir los nombres para cada métrica
$metricNames = [
    1 => "Puntaje Ritmo",
    2 => "Puntaje Tempo"
];

// Inicializamos el arreglo de datos para cada métrica
$data = [];
foreach ($metricNames as $index => $name) {
    $data[$name] = [];
}

// Consulta SQL: agrupar por modalidad y mes, sumando los puntajes
$sql = "SELECT 
            LOWER(TRIM(modalidad_deporte)) AS modality,
            DATE_FORMAT(fecha_registro, '%Y-%m') AS mes,
            SUM(puntaje_ritmo) AS sum_p1,
            SUM(puntaje_tempo) AS sum_p2
        FROM ritmo_tempo
        GROUP BY modality, mes
        ORDER BY mes ASC, modality ASC";

$result = $conn->query($sql);
if (!$result) {
    die("Error en la consulta: " . $conn->error);
}

while ($row = $result->fetch_assoc()) {
    $mod = $row['modality'];
    // Normalizar la modalidad quitando acentos
    $modNormalized = removeAccents($mod);
    if (!in_array($modNormalized, $modalitiesSpecific)) {
        $modNormalized = "ninguna";
    }
    $mes = $row['mes'];
    
    // Para cada métrica, almacenar la sumatoria por modalidad y mes
    for ($i = 1; $i <= 2; $i++) {
        $metricName = $metricNames[$i];
        if (!isset($data[$metricName][$modNormalized])) {
            $data[$metricName][$modNormalized] = [];
        }
        if (!isset($data[$metricName][$modNormalized][$mes])) {
            $data[$metricName][$modNormalized][$mes] = 0;
        }
        $data[$metricName][$modNormalized][$mes] += (int)$row["sum_p$i"];
    }
}

$conn->close();
echo json_encode($data);
?>
