<?php
// archivo get_pieAnaEstAteVelProChartData.php

header('Content-Type: application/json');
include 'db_config.php';

// Usamos la tabla atencion_velocidad_procesamiento

// La siguiente consulta utiliza REPLACE para quitar el acento de la "ó" y agrupar correctamente
$sql = "
SELECT 
    CASE 
        WHEN REPLACE(LOWER(TRIM(modalidad_deporte)),'ó','o') 
             IN ('baja intensidad y equilibrio', 'resistencia moderada', 'aerobicos adaptados')
            THEN REPLACE(LOWER(TRIM(modalidad_deporte)),'ó','o')
        ELSE 'ninguna'
    END AS modality,
    SUM(aciertos) AS total_entries
FROM atencion_velocidad_procesamiento
GROUP BY modality
";

$result = $conn->query($sql);

$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        if (!isset($data[$mod])) {
            $data[$mod] = 0;
        }
        $data[$mod] += (int)$row['total_entries'];
    }
}
$conn->close();

$pieData = [];
foreach ($data as $modality => $total_entries) {
    $pieData[] = [
        'modality' => $modality,
        'total_entries' => $total_entries
    ];
}
echo json_encode($pieData);
?>
