<?php
// archivo get_pieAnaEstAteConChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir la tabla a consultar
$tables = [
  ['name' => 'atencion_concentracion']
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"  // Sin acento
];

$data = []; // Aquí acumularemos los aciertos globales por modalidad

foreach ($tables as $table) {
    $tableName = $table['name'];
    
    // Consulta: Se aplica LOWER y TRIM en la modalidad para estandarizar
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, SUM(aciertos) AS total_aciertos
            FROM $tableName
            GROUP BY modality";
    
    $result = $conn->query($sql);
    if (!$result) {
        die("Error en la consulta: " . $conn->error);
    }
    
    while ($row = $result->fetch_assoc()){
        // La modalidad ya viene en minúsculas y sin espacios
        $mod = $row['modality'];
        // Eliminamos acentos para normalizar (por ejemplo, convertir "aeróbicos adaptados" a "aerobicos adaptados")
        $modNormalized = removeAccents($mod);
        // Si no está en las modalidades válidas, asignar "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        if (!isset($data[$modNormalized])) {
            $data[$modNormalized] = 0;
        }
        $data[$modNormalized] += (int)$row['total_aciertos'];
    }
}
$conn->close();

// Preparar la salida para el JS
$pieData = [];
foreach ($data as $modality => $total_aciertos) {
    $pieData[] = [
        'modality' => $modality,
        'total_aciertos' => $total_aciertos
    ];
}
echo json_encode($pieData);
?>
