<?php
// archivo get_pieAnaEstDesGloCueAutChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir la(s) tabla(s) a consultar
$tables = [
    ['name' => 'cuestionarios_satisfaccion']
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"  // Sin acento
];

// Arreglos para acumular los datos de bienestar y motivación
$dataBienestar = [];
$dataMotivacion = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    // Se usa un único query que obtiene la suma de ambas columnas
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, 
                   SUM(bienestar_post) AS total_bienestar, 
                   SUM(motivacion_post) AS total_motivacion
            FROM $tableName
            GROUP BY modality";
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        // Si la modalidad no es una de las específicas, se agrupa en "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        if (!isset($dataBienestar[$modNormalized])) {
            $dataBienestar[$modNormalized] = 0;
        }
        if (!isset($dataMotivacion[$modNormalized])) {
            $dataMotivacion[$modNormalized] = 0;
        }
        $dataBienestar[$modNormalized] += (int)$row['total_bienestar'];
        $dataMotivacion[$modNormalized] += (int)$row['total_motivacion'];
    }
}
$conn->close();

// Preparar los arreglos de salida para cada set de datos
$bienestarData = [];
foreach ($dataBienestar as $modality => $total_bienestar) {
    $bienestarData[] = [
        'modality' => $modality,
        'total'    => $total_bienestar
    ];
}

$motivacionData = [];
foreach ($dataMotivacion as $modality => $total_motivacion) {
    $motivacionData[] = [
        'modality' => $modality,
        'total'    => $total_motivacion
    ];
}

// Se envía como un objeto con dos propiedades: bienestar y motivacion
$response = [
    "bienestar"  => $bienestarData,
    "motivacion" => $motivacionData
];

echo json_encode($response);
?>
